/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.watchdog;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.watchdog.WatchdogTimer;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_watchdog")
public final class WatchdogTimerConfig
implements DeviceConfig<WatchdogTimer>,
DeviceConfig.HardwareAddressing {
    private String controllerName;
    private int controllerNumber = -1;
    private int timerNumber = -1;

    @DontRenameMethod
    WatchdogTimerConfig() {
    }

    public WatchdogTimerConfig(String string, int n) {
        this.controllerName = string;
        this.timerNumber = n;
        string.length();
        if (-1 > n) {
            throw new IllegalArgumentException();
        }
    }

    public WatchdogTimerConfig(int n, int n2) {
        this.controllerNumber = n;
        this.timerNumber = n2;
        if (-1 > n2 || -1 > n) {
            throw new IllegalArgumentException();
        }
    }

    public static WatchdogTimerConfig deserialize(InputStream inputStream) throws IOException {
        return (WatchdogTimerConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getTimerNumber() {
        return this.timerNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 79);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }
}

