/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.uart;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.uart.UART;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_uart")
public final class UARTConfig
implements DeviceConfig<UART>,
DeviceConfig.HardwareAddressing {
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int DATABITS_9 = 9;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_1_5 = 2;
    public static final int STOPBITS_2 = 3;
    private String controllerName;
    private int channelNumber = -1;
    private int controllerNumber = -1;
    private int baudRate = 9600;
    private int dataBits = 8;
    private int flowcontrol;
    private int inputBufferSize = -1;
    private int outputBufferSize = -1;
    private int parity;
    private int stopBits = 1;

    @DontRenameMethod
    UARTConfig() {
    }

    @Deprecated
    public UARTConfig(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, -1, -1);
    }

    @Deprecated
    public UARTConfig(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.controllerNumber = n;
        this.channelNumber = n2;
        this.baudRate = n3;
        this.dataBits = n4;
        this.stopBits = n6;
        this.parity = n5;
        this.flowcontrol = n7;
        this.inputBufferSize = n8;
        this.outputBufferSize = n9;
        this.checkParameters();
    }

    @Deprecated
    public UARTConfig(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this(string, n, n2, n3, n4, n5, n6, -1, -1);
    }

    @Deprecated
    public UARTConfig(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.controllerName = string;
        this.channelNumber = n;
        this.baudRate = n2;
        this.dataBits = n3;
        this.stopBits = n5;
        this.parity = n4;
        this.flowcontrol = n6;
        this.inputBufferSize = n7;
        this.outputBufferSize = n8;
        string.length();
        this.checkParameters();
    }

    private void checkParameters() {
        if (null == this.controllerName && this.controllerNumber < -1 || this.channelNumber < -1 || this.baudRate <= 0 || this.dataBits < 5 || this.dataBits > 9 || this.parity < 0 || this.parity > 4 || this.stopBits < 1 || this.stopBits > 3 || 0 != (this.flowcontrol & 0xFFFFFFF0) || 0 != (this.flowcontrol & 1) && 0 != (this.flowcontrol & 4) || 0 != (this.flowcontrol & 2) && 0 != (this.flowcontrol & 8) || this.inputBufferSize < -1 || this.outputBufferSize < -1) {
            throw new IllegalArgumentException();
        }
    }

    public static UARTConfig deserialize(InputStream inputStream) throws IOException {
        return (UARTConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getFlowControlMode() {
        return this.flowcontrol;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getParity() {
        return this.parity;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int hashCode() {
        return Platform.hash(this, 7, 53);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    @API(value="device-io_1.1_uart")
    public static final class Builder {
        private final UARTConfig instance = new UARTConfig();

        public UARTConfig build() {
            return (UARTConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            this.instance.checkParameters();
            return this;
        }

        public Builder setChannelNumber(int n) {
            this.instance.channelNumber = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setControllerNumber(int n) {
            this.instance.controllerNumber = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setBaudRate(int n) {
            this.instance.baudRate = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setDataBits(int n) {
            this.instance.dataBits = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setFlowControlMode(int n) {
            this.instance.flowcontrol = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setInputBufferSize(int n) {
            this.instance.inputBufferSize = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            this.instance.outputBufferSize = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setParity(int n) {
            this.instance.parity = n;
            this.instance.checkParameters();
            return this;
        }

        public Builder setStopBits(int n) {
            this.instance.stopBits = n;
            this.instance.checkParameters();
            return this;
        }
    }
}

