/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.pwm;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;
import jdk.dio.pwm.PWMChannel;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_pwm")
public final class PWMChannelConfig
implements DeviceConfig<PWMChannel>,
DeviceConfig.HardwareAddressing {
    public static final int IDLE_STATE_HIGH = 0;
    public static final int IDLE_STATE_LOW = 1;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private String controllerName;
    private int channelNumber = -1;
    private int controllerNumber = -1;
    private GPIOPinConfig outputConfig;
    private int idleState = -1;
    private int pulsePeriod = -1;
    private long scaleFactor = 0x3FF0000000000000L;
    private int pulseAlignment = -1;
    private int outputBufferSize = -1;

    @DontRenameMethod
    PWMChannelConfig() {
    }

    @Deprecated
    public PWMChannelConfig(int n, int n2, int n3, int n4, int n5) {
        this.controllerNumber = n;
        this.channelNumber = n2;
        this.idleState = n3;
        this.pulsePeriod = n4;
        this.pulseAlignment = n5;
        this.checkParameters();
    }

    @Deprecated
    public PWMChannelConfig(int n, int n2, int n3, int n4, int n5, GPIOPinConfig gPIOPinConfig) {
        this(n, n2, n3, n4, n5);
        PWMChannelConfig.checkOutput(gPIOPinConfig);
        this.outputConfig = gPIOPinConfig;
    }

    @Deprecated
    public PWMChannelConfig(String string, int n, int n2, int n3, int n4) {
        this(-1, n, n2, n3, n4);
        string.length();
        this.controllerName = string;
    }

    @Deprecated
    public PWMChannelConfig(String string, int n, int n2, int n3, int n4, GPIOPinConfig gPIOPinConfig) {
        this(-1, n, n2, n3, n4, gPIOPinConfig);
        string.length();
        this.controllerName = string;
    }

    private static void checkOutput(GPIOPinConfig gPIOPinConfig) {
        if (gPIOPinConfig.getDirection() != 1 && gPIOPinConfig.getDirection() != 3) {
            throw new IllegalArgumentException(gPIOPinConfig.toString());
        }
    }

    private static void checkIdle(int n) {
        if (n < -1 || n > 1) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private static void checkAligment(int n) {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private void checkParameters() {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntValue(this.channelNumber);
        PWMChannelConfig.checkIdle(this.idleState);
        Utils.checkGreaterThanZero(this.pulsePeriod);
        PWMChannelConfig.checkAligment(this.pulseAlignment);
    }

    public static PWMChannelConfig deserialize(InputStream inputStream) throws IOException {
        return (PWMChannelConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public GPIOPinConfig getOutputConfig() {
        return this.outputConfig;
    }

    @Deprecated
    public GPIOPin getOutput() {
        return null;
    }

    public int getPulsePeriod() {
        return this.pulsePeriod;
    }

    public int getIdleState() {
        return this.idleState;
    }

    public int getPulseAlignment() {
        return this.pulseAlignment;
    }

    public double getScaleFactor() {
        return Double.longBitsToDouble(this.scaleFactor);
    }

    public int hashCode() {
        return Platform.hash(this, 5, 79);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    @API(value="device-io_1.1_pwm")
    public static final class Builder {
        private final PWMChannelConfig instance = new PWMChannelConfig();

        public PWMChannelConfig build() {
            return (PWMChannelConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setChannelNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.channelNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setOutputConfig(GPIOPinConfig gPIOPinConfig) {
            if (gPIOPinConfig != null) {
                PWMChannelConfig.checkOutput(gPIOPinConfig);
            }
            this.instance.outputConfig = gPIOPinConfig;
            return this;
        }

        public Builder setIdleState(int n) {
            PWMChannelConfig.checkIdle(n);
            this.instance.idleState = n;
            return this;
        }

        public Builder setPulsePeriod(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.pulsePeriod = n;
            return this;
        }

        public Builder setScaleFactor(double d) {
            Utils.checkDoubleGreaterThanZero(d);
            this.instance.scaleFactor = Double.doubleToLongBits(d);
            return this;
        }

        public Builder setPulseAlignment(int n) {
            PWMChannelConfig.checkAligment(n);
            this.instance.pulseAlignment = n;
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.outputBufferSize = n;
            return this;
        }
    }
}

