/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.gpio;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.gpio.GPIOPin;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_gpio")
public final class GPIOPinConfig
implements DeviceConfig<GPIOPin>,
DeviceConfig.HardwareAddressing {
    public static final int DIR_BOTH_INIT_INPUT = 2;
    public static final int DIR_BOTH_INIT_OUTPUT = 3;
    public static final int DIR_INPUT_ONLY = 0;
    public static final int DIR_OUTPUT_ONLY = 1;
    public static final int MODE_INPUT_PULL_DOWN = 2;
    public static final int MODE_INPUT_PULL_UP = 1;
    public static final int MODE_OUTPUT_OPEN_DRAIN = 8;
    public static final int MODE_OUTPUT_PUSH_PULL = 4;
    public static final int TRIGGER_BOTH_EDGES = 3;
    public static final int TRIGGER_BOTH_LEVELS = 6;
    public static final int TRIGGER_FALLING_EDGE = 1;
    public static final int TRIGGER_HIGH_LEVEL = 4;
    public static final int TRIGGER_LOW_LEVEL = 5;
    public static final int TRIGGER_NONE = 0;
    public static final int TRIGGER_RISING_EDGE = 2;
    private String controllerName;
    private int direction = -1;
    private boolean initValue;
    private int mode = -1;
    private int pinNumber = -1;
    private int controllerNumber = -1;
    private int trigger;

    @DontRenameMethod
    GPIOPinConfig() {
    }

    @Deprecated
    public GPIOPinConfig(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.controllerNumber = n;
        this.pinNumber = n2;
        if (n < -1 || n2 < -1) {
            throw new IllegalArgumentException();
        }
        this.direction = n3;
        this.trigger = n5;
        this.mode = n4;
        this.initValue = bl;
        this.checkAll();
    }

    @Deprecated
    public GPIOPinConfig(String string, int n, int n2, int n3, int n4, boolean bl) {
        this(-1, n, n2, n3, n4, bl);
        string.length();
        this.controllerName = string;
    }

    public static GPIOPinConfig deserialize(InputStream inputStream) throws IOException {
        return (GPIOPinConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getDirection() {
        return this.direction;
    }

    public int getDriveMode() {
        return this.mode;
    }

    public boolean getInitValue() {
        return this.initValue;
    }

    public int getPinNumber() {
        return this.pinNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public int hashCode() {
        return Platform.hash(this, 7, 59);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private static void checkDirection(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(ExceptionMessage.format(48, new Object[0]));
        }
    }

    private static void checkMode(int n) {
        if (-1 != n && (0 == n || 0 != (n & 0xFFFFFFF0) || 3 == (n & 3) || 12 == (n & 0xC))) {
            throw new IllegalArgumentException(ExceptionMessage.format(49, new Object[0]));
        }
    }

    private static void checkTrigger(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException(ExceptionMessage.format(47, new Object[0]));
        }
    }

    private void checkConsistency() {
        if (this.direction == 1 && this.trigger != 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(57, new Object[0]));
        }
        switch (this.direction) {
            case 0: {
                if (-1 == this.mode || 0 == (this.mode & 0xFFFFFFFC)) break;
                throw new IllegalArgumentException(ExceptionMessage.format(60, new Object[0]));
            }
            case 1: {
                if (-1 == this.mode || 0 == (this.mode & 0xFFFFFFF3)) break;
                throw new IllegalArgumentException(ExceptionMessage.format(60, new Object[0]));
            }
            case 2: 
            case 3: {
                if (-1 == this.mode || this.mode == 10 || this.mode == 6 || this.mode == 9 || this.mode == 5) break;
                throw new IllegalArgumentException(ExceptionMessage.format(60, new Object[0]));
            }
            default: {
                throw new IllegalArgumentException(ExceptionMessage.format(60, new Object[0]));
            }
        }
    }

    private void checkAll() {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntValue(this.pinNumber);
        GPIOPinConfig.checkDirection(this.direction);
        GPIOPinConfig.checkMode(this.mode);
        GPIOPinConfig.checkTrigger(this.trigger);
        this.checkConsistency();
    }

    @API(value="device-io_1.1_gpio")
    public static final class Builder {
        private final GPIOPinConfig instance = new GPIOPinConfig();

        public GPIOPinConfig build() {
            if (this.instance.direction == -1) {
                throw new IllegalStateException(ExceptionMessage.format(48, new Object[0]));
            }
            this.instance.checkConsistency();
            return this.instance;
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setPinNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.pinNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setDirection(int n) {
            GPIOPinConfig.checkDirection(n);
            this.instance.direction = n;
            return this;
        }

        public Builder setInitValue(boolean bl) {
            this.instance.initValue = bl;
            return this;
        }

        public Builder setDriveMode(int n) {
            GPIOPinConfig.checkMode(n);
            this.instance.mode = n;
            return this;
        }

        public Builder setTrigger(int n) {
            GPIOPinConfig.checkTrigger(n);
            this.instance.trigger = n;
            return this;
        }
    }
}

