/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.generic;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.generic.GenericDevice;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_generic")
public final class GenericDeviceConfig
implements DeviceConfig<GenericDevice>,
DeviceConfig.HardwareAddressing {
    private String controllerName;
    private int channelNumber = -1;
    private int controllerNumber = -1;
    private int inputBufferSize = -1;
    private int outputBufferSize = -1;

    @DontRenameMethod
    GenericDeviceConfig() {
    }

    @Deprecated
    public GenericDeviceConfig(int n, int n2) {
        if (n < -1 || n2 < -1) {
            throw new IllegalArgumentException();
        }
        this.controllerNumber = n;
        this.channelNumber = n2;
    }

    @Deprecated
    public GenericDeviceConfig(String string, int n) {
        this(-1, n);
        string.length();
        this.controllerName = string;
    }

    public static GenericDeviceConfig deserialize(InputStream inputStream) throws IOException {
        return (GenericDeviceConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 97);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    @API(value="device-io_1.1_generic")
    public static final class Builder {
        private GenericDeviceConfig instance = new GenericDeviceConfig();

        public GenericDeviceConfig build() {
            return this.instance;
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setChannelNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.channelNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setInputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.inputBufferSize = n;
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.outputBufferSize = n;
            return this;
        }
    }
}

