/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.dac;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.dac.DACChannel;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_dac")
public final class DACChannelConfig
implements DeviceConfig<DACChannel>,
DeviceConfig.HardwareAddressing {
    private String controllerName;
    private int channelNumber = -1;
    private int controllerNumber = -1;
    private int resolution = -1;
    private int samplingInterval = -1;
    private long scaleFactor = 0x3FF0000000000000L;
    private int outputBufferSize = -1;

    @DontRenameMethod
    DACChannelConfig() {
    }

    @Deprecated
    public DACChannelConfig(int n, int n2, int n3, int n4) {
        this.controllerNumber = n;
        this.channelNumber = n2;
        this.resolution = n3;
        this.samplingInterval = n4;
        this.checkValues();
    }

    @Deprecated
    public DACChannelConfig(String string, int n, int n2, int n3) {
        this.controllerName = string;
        this.channelNumber = n;
        this.resolution = n2;
        this.samplingInterval = n3;
        string.length();
        this.checkValues();
    }

    public static DACChannelConfig deserialize(InputStream inputStream) throws IOException {
        return (DACChannelConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public double getScaleFactor() {
        return Double.longBitsToDouble(this.scaleFactor);
    }

    public int hashCode() {
        return Platform.hash(this, 5, 13);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private void checkValues() {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntValue(this.channelNumber);
        Utils.checkGreaterThanZero(this.resolution);
        Utils.checkGreaterThanZero(this.samplingInterval);
    }

    @API(value="device-io_1.1_dac")
    public static final class Builder {
        private final DACChannelConfig instance = new DACChannelConfig();

        public DACChannelConfig build() {
            return (DACChannelConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setChannelNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.channelNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setResolution(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.resolution = n;
            return this;
        }

        public Builder setSamplingInterval(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.samplingInterval = n;
            return this;
        }

        public Builder setScaleFactor(double d) {
            Utils.checkDoubleGreaterThanZero(d);
            this.instance.scaleFactor = Double.doubleToLongBits(d);
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.outputBufferSize = n;
            return this;
        }
    }
}

