/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio;

import apimarker.API;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Utils;
import java.security.Permission;
import java.security.PermissionCollection;
import jdk.dio.PeripheralPermissionCollection;

@API(value="device-io_1.1")
public abstract class DevicePermission
extends Permission {
    public static final String OPEN = "open";
    public static final String POWER_MANAGE = "powermanage";
    private String myActions;
    private String thisDevice;
    private String thisChannel;

    public DevicePermission(String string) {
        super(string.toString());
        String[] stringArray = Utils.parseDevicePermissionName(string);
        this.thisDevice = stringArray[0];
        this.thisChannel = stringArray[1];
        this.myActions = OPEN;
    }

    public DevicePermission(String string, String string2) {
        super(string.toString());
        if (null == string2) {
            throw new IllegalArgumentException(ExceptionMessage.format(17, new Object[0]));
        }
        String[] stringArray = Utils.parseDevicePermissionName(string);
        this.thisDevice = stringArray[0];
        this.thisChannel = stringArray[1];
        this.myActions = Utils.verifyAndOrderDeviceActions(string2);
    }

    @Override
    public boolean equals(Object object) {
        return DevicePermission.equals(this, object);
    }

    static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null || object.getClass() != object2.getClass()) {
            return false;
        }
        Permission permission = (Permission)object;
        Permission permission2 = (Permission)object2;
        return permission.getName().equals(permission2.getName()) && permission.getActions().equals(permission2.getActions());
    }

    @Override
    public String getActions() {
        return this.myActions;
    }

    @Override
    public int hashCode() {
        return (this.getName() + this.getActions()).hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        return this.privateImplies(permission);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " '" + this.getName() + "' " + this.getActions();
    }

    boolean privateImplies(Permission permission) {
        if (!Utils.implies(this.getActions(), permission.getActions())) {
            return false;
        }
        String string = ((DevicePermission)permission).thisDevice;
        String string2 = ((DevicePermission)permission).thisChannel;
        if (!"*".equals(this.thisDevice) && (this.thisDevice.endsWith("*") ? this.thisDevice.length() > string.length() || !string.startsWith(this.thisDevice.substring(0, this.thisDevice.length() - 1)) : !this.thisDevice.equals(string))) {
            return false;
        }
        if (!"*".equals(this.thisChannel)) {
            if (0 == this.thisChannel.length() && (0 == string2.length() || "*".equals(string2))) {
                return true;
            }
            return this.thisChannel.equals(string2);
        }
        return true;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new PeripheralPermissionCollection(this.getClass());
    }
}

