/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.uart.impl;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.RegistryData;
import java.io.IOException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.uart.UART;
import jdk.dio.uart.UARTConfig;

public final class UARTRegistryFactory
extends DeviceRegistryFactory {
    private static final String BAUD_RATE = "baudRate";
    private static final String DATA_BITS = "dataBits";
    private static final String FLOW_CONTROL = "flowControl";
    private static final String PARITY = "parity";
    private static final String STOP_BITS = "stopBits";
    private static final String TYPE_VALUE = "uart.UART";

    @Override
    public DeviceDescriptor<UART> createDeviceDescriptor(int n, RegistryData registryData) throws IOException {
        String string = registryData.getCharacterProperty("name");
        String[] stringArray = super.getProperties(registryData);
        return new PeripheralDescriptorImpl<UART>(n, string, UARTRegistryFactory.createConfig(registryData), UART.class, stringArray);
    }

    @Override
    public RegistryData createRegistryData(DeviceDescriptor deviceDescriptor) {
        UARTConfig uARTConfig = (UARTConfig)deviceDescriptor.getConfiguration();
        String string = deviceDescriptor.getName();
        RegistryData registryData = UARTRegistryFactory.createData(uARTConfig);
        registryData.putCharacterProperty("deviceType", TYPE_VALUE);
        if (string != null) {
            registryData.putCharacterProperty("name", string);
        }
        super.putProperties(registryData, deviceDescriptor.getProperties());
        return registryData;
    }

    static UARTConfig createConfig(RegistryData registryData) {
        UARTConfig uARTConfig;
        String string = registryData.getCharacterProperty("controllerName");
        int n = registryData.getIntegerProperty(BAUD_RATE, -1);
        int n2 = registryData.getIntegerProperty(DATA_BITS, -1);
        int n3 = registryData.getIntegerProperty(FLOW_CONTROL, -1);
        int n4 = registryData.getIntegerProperty(PARITY, -1);
        int n5 = registryData.getIntegerProperty(STOP_BITS, -1);
        int n6 = registryData.getIntegerProperty("channelNumber", -1);
        if (null == string) {
            int n7 = registryData.getIntegerProperty("controllerNumber", -1);
            uARTConfig = new UARTConfig(n7, n6, n, n2, n4, n5, n3);
        } else {
            uARTConfig = new UARTConfig(string, n6, n, n2, n4, n5, n3);
        }
        return uARTConfig;
    }

    static RegistryData createData(UARTConfig uARTConfig) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        RegistryData registryData = new RegistryData();
        String string = uARTConfig.getControllerName();
        if (string != null) {
            registryData.putCharacterProperty("controllerName", string);
        }
        if ((n7 = uARTConfig.getControllerNumber()) != -1) {
            registryData.putIntegerProperty("controllerNumber", n7);
        }
        if ((n6 = uARTConfig.getBaudRate()) != -1) {
            registryData.putIntegerProperty(BAUD_RATE, n6);
        }
        if ((n5 = uARTConfig.getDataBits()) != -1) {
            registryData.putIntegerProperty(DATA_BITS, n5);
        }
        if ((n4 = uARTConfig.getFlowControlMode()) != -1) {
            registryData.putIntegerProperty(FLOW_CONTROL, n4);
        }
        if ((n3 = uARTConfig.getParity()) != -1) {
            registryData.putIntegerProperty(PARITY, n3);
        }
        if ((n2 = uARTConfig.getStopBits()) != -1) {
            registryData.putIntegerProperty(STOP_BITS, n2);
        }
        if ((n = uARTConfig.getChannelNumber()) != -1) {
            registryData.putIntegerProperty("channelNumber", n);
        }
        return registryData;
    }
}

