/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.spibus.impl;

import com.oracle.dio.impl.Transaction;
import com.oracle.dio.spibus.impl.SPICompositeMessageImpl;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.spibus.InvalidWordLengthException;
import jdk.dio.spibus.SPICompositeMessage;
import jdk.dio.spibus.SPIDevice;
import jdk.dio.spibus.SPIDeviceConfig;
import jdk.dio.spibus.SPIPermission;

class SPISlaveImpl
extends Transaction<SPIDevice>
implements SPIDevice {
    private int byteNum;
    private int bitNum;

    public SPISlaveImpl(DeviceDescriptor<SPIDevice> deviceDescriptor, int n) throws IOException, DeviceNotFoundException, InvalidDeviceConfigException {
        super(deviceDescriptor, n);
        SPIPermission sPIPermission = new SPIPermission(this.getSecurityName());
        AccessController.checkPermission(sPIPermission);
        SPIDeviceConfig sPIDeviceConfig = (SPIDeviceConfig)deviceDescriptor.getConfiguration();
        if (sPIDeviceConfig.getControllerName() != null) {
            throw new InvalidDeviceConfigException(ExceptionMessage.format(22, new Object[0]));
        }
        this.openSPIDeviceByConfig0(sPIDeviceConfig.getControllerNumber(), sPIDeviceConfig.getAddress(), sPIDeviceConfig.getCSActiveLevel(), sPIDeviceConfig.getClockFrequency(), sPIDeviceConfig.getClockMode(), sPIDeviceConfig.getWordLength(), sPIDeviceConfig.getBitOrdering(), n == 1);
        this.initPowerManagement();
        this.bitNum = this.getWordLength0();
        if (this.bitNum > 32) {
            throw new IOException(ExceptionMessage.format(87, this.bitNum));
        }
        this.byteNum = (this.bitNum - 1) / 8 + 1;
    }

    @Override
    public SPICompositeMessage createCompositeMessage() {
        return new SPICompositeMessageImpl(this);
    }

    private String getSecurityName() {
        SPIDeviceConfig sPIDeviceConfig = (SPIDeviceConfig)this.dscr.getConfiguration();
        String string = -1 == sPIDeviceConfig.getControllerNumber() ? "" : String.valueOf(sPIDeviceConfig.getControllerNumber());
        string = -1 == sPIDeviceConfig.getAddress() ? string : string + ":" + Integer.toString(sPIDeviceConfig.getAddress(), 16);
        return string;
    }

    protected void checkPowerPermission() {
        SPIDeviceConfig sPIDeviceConfig = (SPIDeviceConfig)this.dscr.getConfiguration();
        String string = -1 == sPIDeviceConfig.getControllerNumber() ? "" : String.valueOf(sPIDeviceConfig.getControllerNumber());
        string = -1 == sPIDeviceConfig.getAddress() ? string : string + ":" + sPIDeviceConfig.getAddress();
        SPIPermission sPIPermission = new SPIPermission(string, "powermanage");
        AccessController.checkPermission(sPIPermission);
    }

    @Override
    public synchronized int getWordLength() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.getWordLength0();
    }

    @Override
    public ByteBuffer prepareBuffer(ByteBuffer byteBuffer, int n) throws IOException, ClosedDeviceException {
        return (ByteBuffer)super.prepareBufferInt(byteBuffer, n);
    }

    @Override
    public int read() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.byteNum);
        this.transferInternal(null, 0, byteBuffer);
        return this.byteArray2int(byteBuffer);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return this.read(0, byteBuffer);
    }

    @Override
    public int read(int n, ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (0 > n) {
            throw new IllegalArgumentException();
        }
        this.checkBuffer(byteBuffer);
        return this.transferInternal(null, n, byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkBuffer(byteBuffer);
        return this.transferInternal(byteBuffer, 0, null);
    }

    @Override
    public void write(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.writeAndRead(n);
    }

    @Override
    public int writeAndRead(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return this.writeAndRead(byteBuffer, 0, byteBuffer2);
    }

    @Override
    public int writeAndRead(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (0 > n) {
            throw new IllegalArgumentException();
        }
        this.checkBuffer(byteBuffer);
        this.checkBuffer(byteBuffer2);
        return this.transferInternal(byteBuffer, n, byteBuffer2);
    }

    @Override
    public int writeAndRead(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        ByteBuffer byteBuffer = this.int2byteArray(n);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        this.transferInternal(byteBuffer, 0, byteBuffer2);
        return this.byteArray2int(byteBuffer2);
    }

    protected int getGrpID() {
        return this.getGrpID0();
    }

    @Override
    public ByteBuffer getInputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getOutputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void checkBuffer(Buffer buffer) {
        if (buffer.remaining() % this.byteNum != 0) {
            throw new InvalidWordLengthException(ExceptionMessage.format(88, new Object[0]));
        }
    }

    private ByteBuffer int2byteArray(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.byteNum);
        for (int i = 0; i < this.byteNum; ++i) {
            byteBuffer.put((byte)(n >> 8 * (this.byteNum - i - 1) & 0xFF));
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private int byteArray2int(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        int n = 0;
        for (int i = 0; i < this.byteNum; ++i) {
            byte by = byteBuffer.get();
            n |= (by & 0xFF) << 8 * (this.byteNum - i - 1);
        }
        return n;
    }

    private int transferInternal(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) throws IOException {
        int n2 = byteBuffer2 != null ? byteBuffer2.remaining() : byteBuffer.remaining();
        SPICompositeMessage sPICompositeMessage = this.createCompositeMessage();
        if (byteBuffer == null && byteBuffer2 != null) {
            sPICompositeMessage.appendRead(n, byteBuffer2);
        } else if (byteBuffer2 == null && byteBuffer != null) {
            sPICompositeMessage.appendWrite(byteBuffer);
        } else {
            sPICompositeMessage.appendWriteAndRead(byteBuffer, n, byteBuffer2);
        }
        sPICompositeMessage.transfer();
        return n2;
    }

    void transferWithLock(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        try {
            this.conditionalLock();
            this.writeAndRead0(byteBuffer, byteBuffer2);
        }
        finally {
            this.conditionalUnlock();
        }
    }

    void beginTransaction() throws IOException, IllegalStateException {
        this.conditionalLock();
        this.begin0();
    }

    void endTransaction() throws IllegalStateException {
        this.end0();
        this.conditionalUnlock();
    }

    private native int begin0() throws IOException, UnsupportedOperationException, IllegalStateException;

    private native int end0() throws IllegalStateException;

    private native void openSPIDeviceByConfig0(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    private native void writeAndRead0(ByteBuffer var1, ByteBuffer var2) throws IOException;

    private native int getGrpID0();

    private native int getWordLength0();

    private native int getByteOrdering0();
}

