/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.registry;

import com.oracle.dio.registry.RegistryList;
import com.oracle.dio.utils.Logging;
import java.util.Enumeration;
import java.util.Hashtable;

public final class RegistryData {
    private final Hashtable<String, Object> data;

    public RegistryData() {
        this.data = new Hashtable();
    }

    private RegistryData(Hashtable<String, Object> hashtable) {
        this.data = hashtable;
    }

    public String getCharacterProperty(String string) {
        return (String)this.data.get(string);
    }

    public void putCharacterProperty(String string, String string2) {
        if (null == string2) {
            Logging.reportInformation("RegistryData ignores null element");
            return;
        }
        this.data.put(string, string2);
    }

    public int getIntegerProperty(String string, int n) {
        return (int)this.getIntegerProperty(string, (long)n);
    }

    public long getIntegerProperty(String string, long l) {
        String string2 = (String)this.data.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            int n = 10;
            if (string2.startsWith("0x")) {
                string2 = string2.substring(2);
                n = 16;
            }
            return Long.parseLong(string2, n);
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            return l;
        }
    }

    public void putIntegerProperty(String string, long l, int n) {
        this.data.put(string, Long.toString(l, n));
    }

    public void putIntegerProperty(String string, int n) {
        this.data.put(string, Integer.toString(n));
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = (String)this.data.get(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equals(string2) || "1".equals(string2) || "yes".equals(string2)) {
            return true;
        }
        if ("false".equals(string2) || "0".equals(string2) || "no".equals(string2)) {
            return false;
        }
        return bl;
    }

    public void putBooleanProperty(String string, boolean bl) {
        this.data.put(string, Boolean.toString(bl));
    }

    public RegistryData getCompoundProperty(String string) {
        return (RegistryData)this.data.get(string);
    }

    public void putCompoundProperty(String string, RegistryData registryData) {
        this.data.put(string, registryData);
    }

    public RegistryList getListProperty(String string) {
        return (RegistryList)this.data.get(string);
    }

    public void putListProperty(String string, RegistryList registryList) {
        this.data.put(string, registryList);
    }

    public Enumeration<String> keys() {
        return this.data.keys();
    }

    public boolean hasProperty(String string) {
        return this.data.containsKey(string);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void copyProperty(String string, RegistryData registryData) {
        Object object = registryData.data.get(string);
        this.data.put(string, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            stringBuffer.append(string + ":");
            Object object = this.data.get(string);
            if (object instanceof RegistryData) {
                stringBuffer.append('{');
                stringBuffer.append(object.toString());
                stringBuffer.append('}');
            } else {
                stringBuffer.append(object.toString());
            }
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public RegistryData cloneRegistryData() {
        return new RegistryData((Hashtable)this.data.clone());
    }
}

