/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.registry;

import com.oracle.dio.registry.RegistryData;
import com.oracle.dio.registry.RegistryList;
import java.io.IOException;
import jdk.dio.Device;
import jdk.dio.DeviceDescriptor;

public abstract class DeviceRegistryFactory {
    public static final String DEVICE_TYPE = "deviceType";
    private static final String FACTORY_POSTFIX = "RegistryFactory";

    public abstract DeviceDescriptor createDeviceDescriptor(int var1, RegistryData var2) throws IOException;

    public abstract RegistryData createRegistryData(DeviceDescriptor var1);

    public static String registryFactoryName(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = "com.oracle.dio." + string2 + ".impl." + string3 + FACTORY_POSTFIX;
        return string4;
    }

    public static <T extends Device> String registryFactoryName(Class<T> clazz) {
        String string = clazz.getName();
        if (string.indexOf("jdk.dio.") != 0) {
            return null;
        }
        String string2 = string.substring("jdk.dio.".length());
        return DeviceRegistryFactory.registryFactoryName(string2);
    }

    protected String[] getProperties(RegistryData registryData) {
        RegistryList registryList = registryData.getListProperty("properties");
        String[] stringArray = null;
        if (registryList != null && registryList.size() > 0) {
            stringArray = new String[registryList.size()];
            try {
                System.arraycopy(registryList.toArray(), 0, stringArray, 0, stringArray.length);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }
        return stringArray;
    }

    protected void putProperties(RegistryData registryData, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            RegistryList registryList = new RegistryList();
            for (int i = 0; i < stringArray.length; ++i) {
                registryList.add(stringArray[i]);
            }
            registryData.putListProperty("properties", registryList);
        }
    }
}

