/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.impl;

import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import jdk.dio.Device;
import jdk.dio.DeviceConfig;
import jdk.dio.DeviceDescriptor;
import jdk.dio.spi.DeviceProvider;
import romizer.DontRenameClass;
import serializator.SerializeMe;

@SerializeMe
@DontRenameClass
public final class PeripheralDescriptorImpl<T extends Device<? super T>>
implements DeviceDescriptor<T> {
    private Object config;
    private String clazz;
    private int id = -1;
    private String name;
    private String[] props;
    private String providerClazz;

    public PeripheralDescriptorImpl() {
    }

    public PeripheralDescriptorImpl(int n, String string, DeviceConfig deviceConfig, Class<T> clazz, String[] stringArray) {
        Objects.requireNonNull(deviceConfig);
        this.config = deviceConfig;
        if (null != clazz) {
            this.clazz = clazz.getName();
        }
        this.id = n;
        this.name = string;
        this.props = stringArray == null ? stringArray : (String[])stringArray.clone();
    }

    @Override
    public <C extends DeviceConfig<? super T>> C getConfiguration() {
        if (this.config instanceof DeviceConfig) {
            return (C)((DeviceConfig)this.config);
        }
        return null;
    }

    @Override
    public Class<T> getInterface() {
        if (null != this.clazz) {
            try {
                return Class.forName(this.clazz);
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                Logging.reportError("Can't restore class at PeripheralDescriptorImpl");
            }
        }
        return null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getProperties() {
        return this.props == null ? this.props : (String[])this.props.clone();
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.providerClazz = deviceProvider.getClass().getName();
    }

    public void prepareForSerilization() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!(this.config instanceof byte[])) {
            if (null != this.providerClazz) {
                ((DeviceConfig)this.config).serialize(byteArrayOutputStream);
            } else {
                Platform.serialize(this.config, byteArrayOutputStream);
            }
            byteArrayOutputStream.close();
            this.config = byteArrayOutputStream.toByteArray();
        }
    }

    public void recoverFromSerialization() {
        if (this.config instanceof byte[]) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])this.config);
            try {
                this.config = Platform.deserialize(byteArrayInputStream);
            }
            catch (IOException iOException) {
                Logging.reportInformation("Config is custom DeviceConfig child");
                try {
                    byteArrayInputStream.reset();
                    DeviceProvider deviceProvider = (DeviceProvider)Class.forName(this.providerClazz).newInstance();
                    this.config = deviceProvider.deserialize(byteArrayInputStream);
                }
                catch (Exception exception) {
                    Logging.reportError("Can't restore config object");
                }
            }
        }
    }

    public void setNewID(int n) {
        this.id = n;
    }
}

