/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.impl;

import com.oracle.dio.impl.AbstractPeripheral;
import com.oracle.dio.impl.Event;
import com.oracle.dio.impl.EventHandler;
import com.oracle.dio.impl.EventQueue;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Vector;
import jdk.dio.Device;
import jdk.dio.DeviceEvent;

public final class EventQueueManager
implements EventHandler {
    private final Vector<Integer> registeredTypes = new Vector();
    private final Hashtable<Integer, AbstractPeripheral> listenerRegistry = new Hashtable();
    private static final EventQueueManager instance = new EventQueueManager();
    private final EventQueue queue = EventQueue.getSharedEventQueue();

    public static EventQueueManager getInstance() {
        return instance;
    }

    private EventQueueManager() {
    }

    private int getHash(int n, int n2, long l) {
        return (int)((long)(n * (n + n * n2)) + l);
    }

    public void setEventListener(Class<? extends Device> clazz, int n, AbstractPeripheral abstractPeripheral) {
        int n2 = clazz.hashCode();
        long l = abstractPeripheral.getHandle().getNativeHandle();
        if (!this.registeredTypes.contains(n2)) {
            this.queue.registerForEvent(clazz, this);
            this.registeredTypes.add(n2);
        }
        this.listenerRegistry.put(this.getHash(n2, n, l), abstractPeripheral);
    }

    public void removeEventListener(Class<? extends Device> clazz, int n, AbstractPeripheral abstractPeripheral) {
        int n2 = clazz.hashCode();
        long l = abstractPeripheral.getHandle().getNativeHandle();
        this.listenerRegistry.remove(this.getHash(n2, n, l));
    }

    public void postEvent(AbstractPeripheral abstractPeripheral, int n, DeviceEvent deviceEvent) {
        Tuple tuple = new Tuple(abstractPeripheral.getDescriptor().getInterface(), n, abstractPeripheral, deviceEvent);
        this.queue.postEvent(tuple);
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event instanceof Tuple) {
            Tuple tuple = (Tuple)event;
            tuple.receiver.processDeviceEvent(tuple.eventType, tuple.event);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(event.getPayload());
            long l = byteBuffer.getLong();
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            AbstractPeripheral abstractPeripheral = this.listenerRegistry.get(this.getHash(event.getType().hashCode(), n, l));
            if (abstractPeripheral != null) {
                abstractPeripheral.processNativeEvent(n, n2);
            }
        }
        return true;
    }

    public boolean isDispatchThread() {
        return this.queue.getEventDispatchThread().equals(Thread.currentThread());
    }

    private final class Tuple
    extends Event {
        private final DeviceEvent event;
        private final int eventType;
        private final AbstractPeripheral receiver;

        private Tuple(Class<? extends Device> clazz, int n, AbstractPeripheral abstractPeripheral, DeviceEvent deviceEvent) {
            super(clazz, null);
            this.eventType = n;
            this.receiver = abstractPeripheral;
            this.event = deviceEvent;
        }
    }
}

