/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.i2cbus.impl;

import com.oracle.dio.i2cbus.impl.I2CCombinedMessage;
import com.oracle.dio.power.impl.PowerManagedBase;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Logging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.i2cbus.I2CDevice;
import jdk.dio.i2cbus.I2CDeviceConfig;
import jdk.dio.i2cbus.I2CPermission;

class I2CSlaveImpl
extends PowerManagedBase<I2CDevice>
implements I2CDevice {
    static final int I2C_REGULAR = 0;
    static final int I2C_COMBINED_START = 1;
    static final int I2C_COMBINED_END = 2;
    static final int I2C_COMBINED_BODY = 3;
    private List<BuffersMap> delayedConversions = new LinkedList<BuffersMap>();

    I2CSlaveImpl(DeviceDescriptor<I2CDevice> deviceDescriptor, int n) throws DeviceNotFoundException, InvalidDeviceConfigException {
        super(deviceDescriptor, n);
        I2CPermission i2CPermission = new I2CPermission(this.getSecurityName());
        AccessController.checkPermission(i2CPermission);
        I2CDeviceConfig i2CDeviceConfig = (I2CDeviceConfig)deviceDescriptor.getConfiguration();
        if (i2CDeviceConfig.getControllerName() != null) {
            throw new InvalidDeviceConfigException(ExceptionMessage.format(22, new Object[0]));
        }
        this.open0(i2CDeviceConfig, n == 1);
        this.initPowerManagement();
    }

    @Override
    public I2CDevice.Bus getBus() throws IOException {
        return new I2CDevice.Bus(){

            @Override
            public jdk.dio.i2cbus.I2CCombinedMessage createCombinedMessage() {
                return new I2CCombinedMessage();
            }
        };
    }

    private String getSecurityName() {
        I2CDeviceConfig i2CDeviceConfig = (I2CDeviceConfig)this.dscr.getConfiguration();
        String string = -1 == i2CDeviceConfig.getControllerNumber() ? "" : String.valueOf(i2CDeviceConfig.getControllerNumber());
        string = -1 == i2CDeviceConfig.getAddress() ? string : string + ":" + i2CDeviceConfig.getAddress();
        return string;
    }

    protected void checkPowerPermission() {
        AccessController.checkPermission(new I2CPermission(this.getSecurityName(), "powermanage"));
    }

    private void doCheck(int n, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ByteBuffer getInputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getOutputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        this.read(byteBuffer);
        return byteBuffer.get(0);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return this.read(0, byteBuffer);
    }

    @Override
    public int read(int n, ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.doCheck(n, byteBuffer);
        return this.transfer(0, n, byteBuffer);
    }

    @Override
    public int read(int n, int n2, ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return this.read(n, n2, 0, byteBuffer);
    }

    @Override
    public int read(int n, int n2, int n3, ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (n2 <= 0 || n2 > 4 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.doCheck(n3, byteBuffer);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(new byte[4]);
        byteBuffer2.order(ByteOrder.BIG_ENDIAN);
        byteBuffer2.putInt(n);
        byteBuffer2.position(4 - n2);
        I2CCombinedMessage i2CCombinedMessage = new I2CCombinedMessage();
        i2CCombinedMessage.appendWrite(this, byteBuffer2);
        i2CCombinedMessage.appendRead(this, n3, byteBuffer);
        return i2CCombinedMessage.transfer()[0];
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.doCheck(0, byteBuffer);
        return this.transfer(0, -1, byteBuffer);
    }

    @Override
    public void write(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        byteBuffer.put((byte)n);
        byteBuffer.flip();
        this.write(byteBuffer);
    }

    @Override
    public int write(int n, int n2, ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        boolean bl = false;
        if (n2 <= 0 || n2 > 4 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.doCheck(0, byteBuffer);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4 + byteBuffer.remaining());
        byteBuffer2.order(ByteOrder.BIG_ENDIAN);
        byteBuffer2.putInt(n);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(4 - n2);
        return this.write(byteBuffer2) - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int transfer(int n, int n2, ByteBuffer byteBuffer) throws UnavailableDeviceException, ClosedDeviceException, IOException {
        int n3 = 0;
        if (!byteBuffer.hasRemaining() && n2 <= 0) {
            return 0;
        }
        ByteBuffer byteBuffer2 = this.toDirect(n2, byteBuffer);
        this.checkPowerState();
        Object object = this.handle;
        synchronized (object) {
            try {
                this.conditionalLock();
                n3 = this.transfer0(n2 < 0, byteBuffer2, n);
            }
            finally {
                this.conditionalUnlock();
            }
        }
        byteBuffer2.limit(n3);
        if (n2 > 0) {
            n3 = n3 > n2 ? n3 - n2 : 0;
        }
        object = new BuffersMap(n2, byteBuffer, n3, byteBuffer2);
        return n == 0 ? this.restoreFromDirect((BuffersMap)object) : this.addDelayedConversion((BuffersMap)object);
    }

    private int addDelayedConversion(BuffersMap buffersMap) {
        this.delayedConversions.add(buffersMap);
        return buffersMap.ret;
    }

    void applyDelayedConversions() {
        for (BuffersMap buffersMap : this.delayedConversions) {
            this.restoreFromDirect(buffersMap);
        }
        this.delayedConversions.clear();
    }

    private int restoreFromDirect(BuffersMap buffersMap) {
        ByteBuffer byteBuffer = buffersMap.direct;
        int n = buffersMap.ret;
        int n2 = buffersMap.skip;
        ByteBuffer byteBuffer2 = buffersMap.nonDirect;
        if (n2 > 0) {
            if (n > 0) {
                byteBuffer.position(n2);
                try {
                    byteBuffer2.put(byteBuffer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.reportError(ExceptionMessage.format(23, new Object[0]));
                }
            }
        } else {
            try {
                if (n2 < 0) {
                    byteBuffer2.position(byteBuffer2.position() + n);
                } else {
                    byteBuffer2.put(byteBuffer);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.reportError(ExceptionMessage.format(23, new Object[0]));
            }
        }
        return n;
    }

    private ByteBuffer toDirect(int n, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = n > 0 ? ByteBuffer.allocateDirect(byteBuffer.remaining() + n) : this.convert(byteBuffer, null);
        return byteBuffer2;
    }

    protected synchronized int getGrpID() {
        return this.getGrpID0();
    }

    @Override
    public ByteBuffer prepareBuffer(ByteBuffer byteBuffer, int n) throws IOException, ClosedDeviceException {
        return (ByteBuffer)super.prepareBufferInt(byteBuffer, n);
    }

    private native void open0(Object var1, boolean var2);

    private native int transfer0(boolean var1, ByteBuffer var2, int var3);

    private native int getGrpID0();

    static class BuffersMap {
        int skip;
        int ret;
        ByteBuffer direct;
        ByteBuffer nonDirect;

        BuffersMap(int n, ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2) {
            this.skip = n;
            this.ret = n2;
            this.direct = byteBuffer2;
            this.nonDirect = byteBuffer;
        }
    }
}

