/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.gpio.impl;

import com.oracle.dio.gpio.impl.GPIOPinRegistryFactory;
import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.RegistryData;
import com.oracle.dio.registry.RegistryList;
import java.io.IOException;
import java.util.Enumeration;
import jdk.dio.DeviceDescriptor;
import jdk.dio.gpio.GPIOPinConfig;
import jdk.dio.gpio.GPIOPort;
import jdk.dio.gpio.GPIOPortConfig;

public final class GPIOPortRegistryFactory
extends DeviceRegistryFactory {
    private static final String PINS = "pins";
    private static final String TYPE_VALUE = "gpio.GPIOPort";

    @Override
    public DeviceDescriptor<GPIOPort> createDeviceDescriptor(int n, RegistryData registryData) throws IOException {
        String[] stringArray;
        String string = registryData.getCharacterProperty("name");
        int n2 = registryData.getIntegerProperty("direction", -1);
        int n3 = registryData.getIntegerProperty("initValue", 0);
        RegistryList registryList = registryData.getListProperty(PINS);
        if (registryList == null) {
            return null;
        }
        GPIOPinConfig[] gPIOPinConfigArray = new GPIOPinConfig[registryList.size()];
        Enumeration<?> enumeration = registryList.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            stringArray = stringArray.cloneRegistryData();
            stringArray.putIntegerProperty("direction", n2);
            gPIOPinConfigArray[n4] = GPIOPinRegistryFactory.createConfig((RegistryData)stringArray);
            ++n4;
        }
        GPIOPortConfig gPIOPortConfig = new GPIOPortConfig(n2, n3, gPIOPinConfigArray);
        stringArray = super.getProperties(registryData);
        return new PeripheralDescriptorImpl<GPIOPort>(n, string, gPIOPortConfig, GPIOPort.class, stringArray);
    }

    @Override
    public RegistryData createRegistryData(DeviceDescriptor deviceDescriptor) {
        int n;
        GPIOPortConfig gPIOPortConfig = (GPIOPortConfig)deviceDescriptor.getConfiguration();
        String string = deviceDescriptor.getName();
        RegistryData registryData = new RegistryData();
        registryData.putCharacterProperty("deviceType", TYPE_VALUE);
        if (string != null) {
            registryData.putCharacterProperty("name", string);
        }
        if ((n = gPIOPortConfig.getDirection()) != -1) {
            registryData.putIntegerProperty("direction", n);
        }
        registryData.putIntegerProperty("initValue", gPIOPortConfig.getInitValue());
        GPIOPinConfig[] gPIOPinConfigArray = gPIOPortConfig.getPinConfigs();
        if (gPIOPinConfigArray.length > 0) {
            RegistryList registryList = new RegistryList();
            for (int i = 0; i < gPIOPinConfigArray.length; ++i) {
                RegistryData registryData2 = GPIOPinRegistryFactory.createData(gPIOPinConfigArray[i]);
                registryList.add(registryData2);
            }
            registryData.putListProperty(PINS, registryList);
        }
        super.putProperties(registryData, deviceDescriptor.getProperties());
        return registryData;
    }
}

