/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.gpio.impl;

import com.oracle.dio.impl.EventQueueManager;
import com.oracle.dio.power.impl.PowerManagedBase;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.security.AccessController;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;
import jdk.dio.gpio.GPIOPinPermission;
import jdk.dio.gpio.PinEvent;
import jdk.dio.gpio.PinListener;

class GPIOPinImpl
extends PowerManagedBase<GPIOPin>
implements GPIOPin {
    private PinListener listener;

    GPIOPinImpl(DeviceDescriptor<GPIOPin> deviceDescriptor, int n) throws DeviceNotFoundException, InvalidDeviceConfigException {
        super(deviceDescriptor, n);
        GPIOPinPermission gPIOPinPermission = new GPIOPinPermission(this.getSecurityName());
        AccessController.checkPermission(gPIOPinPermission);
        GPIOPinConfig gPIOPinConfig = (GPIOPinConfig)deviceDescriptor.getConfiguration();
        if (gPIOPinConfig.getControllerName() != null) {
            throw new InvalidDeviceConfigException(ExceptionMessage.format(22, new Object[0]));
        }
        this.openPinByConfig0(gPIOPinConfig.getControllerNumber(), gPIOPinConfig.getPinNumber(), gPIOPinConfig.getDirection(), gPIOPinConfig.getDriveMode(), gPIOPinConfig.getTrigger(), gPIOPinConfig.getInitValue(), n == 1);
        this.initPowerManagement();
    }

    private String getSecurityName() {
        GPIOPinConfig gPIOPinConfig = (GPIOPinConfig)this.dscr.getConfiguration();
        String string = -1 == gPIOPinConfig.getControllerNumber() ? "" : String.valueOf(gPIOPinConfig.getControllerNumber());
        string = -1 == gPIOPinConfig.getPinNumber() ? string : string + ":" + gPIOPinConfig.getPinNumber();
        return string;
    }

    protected void checkPowerPermission() {
        AccessController.checkPermission(new GPIOPinPermission(this.getSecurityName(), "powermanage"));
    }

    @Override
    public synchronized void setTrigger(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        if (0 > n || 6 < n) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.getOutputMode0()) {
            throw new UnsupportedOperationException(ExceptionMessage.format(57, new Object[0]));
        }
        this.setTrigger0(n);
    }

    @Override
    public synchronized int getTrigger() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        return this.getTrigger0();
    }

    @Override
    public synchronized boolean getValue() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        int n = this.readPin0();
        return n == 1;
    }

    @Override
    public synchronized void setValue(boolean bl) throws IOException, UnavailableDeviceException {
        this.checkPowerState();
        if (!this.getOutputMode0()) {
            throw new UnsupportedOperationException(ExceptionMessage.format(52, new Object[0]));
        }
        this.writePin0(bl);
    }

    @Override
    public synchronized int getDirection() throws IOException, UnavailableDeviceException {
        this.checkOpen();
        return this.getOutputMode0() ? 1 : 0;
    }

    @Override
    protected void processNativeEvent(int n, int ... nArray) {
        int n2 = nArray[0];
        PinListener pinListener = this.listener;
        if (null != pinListener) {
            pinListener.valueChanged(new PinEvent(this, n2 > 0));
        }
    }

    @Override
    public synchronized void setInputListener(PinListener pinListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        if (this.getOutputMode0()) {
            throw new UnsupportedOperationException(ExceptionMessage.format(53, new Object[0]));
        }
        if (null == pinListener) {
            EventQueueManager.getInstance().removeEventListener(GPIOPin.class, 0, this);
            if (null != this.listener) {
                try {
                    this.stopNoti0();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.listener = null;
        } else if (this.listener == null) {
            this.listener = pinListener;
            EventQueueManager.getInstance().setEventListener(GPIOPin.class, 0, this);
            try {
                this.startNoti0();
            }
            catch (IOException iOException) {
                this.listener = null;
                throw new UnsupportedOperationException(ExceptionMessage.format(54, new Object[0]));
            }
        } else {
            throw new IllegalStateException(ExceptionMessage.format(55, new Object[0]));
        }
    }

    @Override
    public synchronized void setDirection(int n) throws UnavailableDeviceException, IOException {
        AccessController.checkPermission(new GPIOPinPermission(this.getSecurityName(), "setdirection"));
        this.checkPowerState();
        int n2 = ((GPIOPinConfig)this.dscr.getConfiguration()).getDirection();
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(56, new Object[0]));
        }
        if (1 == n && 0 == n2 || 0 == n && 1 == n2) {
            throw new UnsupportedOperationException(ExceptionMessage.format(57, new Object[0]));
        }
        this.setOutputMode0(n == 1);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            if (null != this.listener) {
                try {
                    this.setInputListener(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.close();
        }
    }

    protected synchronized int getGrpID() {
        return this.getGrpID0();
    }

    private native void openPinByConfig0(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    private native int readPin0() throws IOException;

    private native void writePin0(boolean var1) throws IOException;

    private native void startNoti0() throws IOException;

    private native void stopNoti0() throws IOException;

    private native void setOutputMode0(boolean var1);

    private native boolean getOutputMode0();

    private native void setTrigger0(int var1);

    private native int getTrigger0();

    private native int getGrpID0();
}

