/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.class_1058;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class RenderUtil {
    public static final RGBA DARK_CONTAINER_BORDER_COLOR = new RGBA(0x373737FF);
    public static final RGBA MEDIUM_CONTAINER_BORDER_COLOR = new RGBA(-1953788929);
    public static final RGBA BRIGHT_CONTAINER_BORDER_COLOR = RGBA.WHITE;

    public static void drawContainerBorder(class_4587 poseStack, int x, int y, int width, int height, float blitOffset, RGBA color) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + width - 1, y, y + 1, DARK_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + 1, y, y + height - 1, DARK_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + width - 1, x + width, y, y + 1, MEDIUM_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + 1, y + height - 1, y + height, MEDIUM_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + 1, x + width - 1, y + height - 1, y + height, BRIGHT_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + width - 1, x + width, y + 1, y + height, BRIGHT_CONTAINER_BORDER_COLOR, blitOffset);
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void drawContinuousTexturedBox(class_4587 poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float blitOffset, class_2960 texture, RGBA color) {
        int index;
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y, u, v, 0.00390625f, 0.00390625f, leftBorder, topBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, 0.00390625f, 0.00390625f, rightBorder, topBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, leftBorder, bottomBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, rightBorder, bottomBorder, blitOffset);
        for (index = 0; index < xPasses + (remainderWidth > 0 ? 1 : 0); ++index) {
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y, u + leftBorder, v, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, topBorder, blitOffset);
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, bottomBorder, blitOffset);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, blitOffset);
            }
        }
        for (index = 0; index < yPasses + (remainderHeight > 0 ? 1 : 0); ++index) {
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y + topBorder + index * fillerHeight, u, v + topBorder, 0.00390625f, 0.00390625f, leftBorder, index == yPasses ? remainderHeight : fillerHeight, blitOffset);
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y + topBorder + index * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, 0.00390625f, 0.00390625f, rightBorder, index == yPasses ? remainderHeight : fillerHeight, blitOffset);
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedQuad(class_4587 poseStack, int x, int y, int width, int height, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float blitOffset, class_2960 texture, RGBA color) {
        RenderUtil.drawTexturedQuad(poseStack, x, x + width, y, y + height, uOffset / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, vOffset / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, blitOffset, texture, color);
    }

    public static void drawTexturedQuad(class_4587 poseStack, int x, int y, int width, int height, float blitOffset, class_1058 sprite, RGBA color) {
        RenderUtil.drawTexturedQuad(poseStack, x, x + width, y, y + height, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), blitOffset, sprite.method_45852(), color);
    }

    public static void drawTexturedQuad(class_4587 poseStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float blitOffset, class_2960 texture, RGBA color) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        RenderUtil.addTexturedQuad(bufferBuilder, poseStack, x1, x2, y1, y2, u1, u2, v1, v2, blitOffset);
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void addTexturedRect(class_287 bufferBuilder, class_4587 poseStack, int x, int y, int u, int v, float uScale, float vScale, int width, int height, float blitOffset) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), blitOffset).method_22913((float)u * uScale, (float)(v + height) * vScale).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), blitOffset).method_22913((float)(u + width) * uScale, (float)(v + height) * vScale).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, blitOffset).method_22913((float)(u + width) * uScale, (float)v * vScale).method_1344();
        bufferBuilder.method_22918(matrix, (float)x, (float)y, blitOffset).method_22913((float)u * uScale, (float)v * vScale).method_1344();
    }

    public static void addTexturedQuad(class_287 bufferBuilder, class_4587 poseStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float blitOffset) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, blitOffset).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, blitOffset).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, blitOffset).method_22913(u2, v1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, blitOffset).method_22913(u1, v1).method_1344();
    }

    public static void addColoredQuad(class_287 bufferBuilder, class_4587 poseStack, int x1, int x2, int y1, int y2, RGBA color, float blitOffset) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, blitOffset).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, blitOffset).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, blitOffset).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, blitOffset).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    public static void addQuad(class_287 bufferBuilder, class_4587 poseStack, int x1, int x2, int y1, int y2, float blitOffset) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, blitOffset).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, blitOffset).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, blitOffset).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, blitOffset).method_1344();
    }

    public static void setShaderColor(RGBA rgba) {
        RenderSystem.setShaderColor((float)rgba.getRedComponent(), (float)rgba.getGreenComponent(), (float)rgba.getBlueComponent(), (float)rgba.getAlphaComponent());
    }
}

