/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.gui.elements.AbstractSliderLogic;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.elements.WidgetTextureProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class USlider
extends AbstractSliderLogic
implements PerspectiveRenderable,
BackgroundColorProvider,
TextProvider {
    protected static final AbstractSliderLogic.OnSliderChange EMPTY_SLIDER = AbstractSliderLogic.EMPTY_SLIDER;
    protected static final RGBA WHITE = UButton.WHITE;
    protected static final RGBA LIGHT_GRAY = UButton.LIGHT_GRAY;
    protected final boolean isInContainer;
    protected TextureProvider sliderBackgroundTextureProvider;
    protected RGBA sliderBackgroundColor;
    protected TextureProvider sliderTextureProvider;
    protected RGBA sliderColor;

    public USlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, EMPTY_SLIDER);
    }

    public USlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, AbstractSliderLogic.OnSliderChange slider) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, slider);
        this.isInContainer = isInContainer;
        this.sliderBackgroundTextureProvider = new WidgetTextureProvider((class_339)this, hovered -> 0);
        this.sliderBackgroundColor = WHITE;
        this.sliderTextureProvider = new WidgetTextureProvider((class_339)this, hovered -> hovered != false ? 2 : 1);
        this.sliderColor = WHITE;
    }

    public RGBA getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public void setSliderBackgroundColor(RGBA sliderBackgroundColor) {
        this.sliderBackgroundColor = sliderBackgroundColor;
    }

    public RGBA getSliderColor() {
        return this.sliderColor;
    }

    public void setSliderColor(RGBA sliderColor) {
        this.sliderColor = sliderColor;
    }

    @Override
    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderButtonLikeWidget(this, this.sliderBackgroundTextureProvider, poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25353(poseStack, class_310.method_1551(), mouseX, mouseY);
        if (this.field_22764) {
            RenderUtil.drawContinuousTexturedBox(poseStack, this.field_22760 + (int)(this.value * (double)(this.field_22758 - 8)), this.field_22761, this.sliderTextureProvider.getU(), this.sliderTextureProvider.getV(), 8, this.field_22759, this.sliderBackgroundTextureProvider.getWidth(), this.sliderTextureProvider.getHeight(), 2, 3, 2, 2, this.method_25305(), this.sliderTextureProvider.getTexture(), this.getCurrentSliderColor(poseStack, mouseX, mouseY, partialTicks));
        }
    }

    @Override
    public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderText(this, poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public RGBA getCurrentBackgroundColor(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderBackgroundColor;
    }

    public RGBA getCurrentSliderColor(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderColor;
    }

    @Override
    public class_2561 getCurrentText() {
        return this.method_25369();
    }

    @Override
    public RGBA getCurrentTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.field_22763 ? this.textColor : this.disabledTextColor;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.changeSliderValue(mouseX);
        if (this.isInContainer) {
            this.dragging = true;
        }
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.isInContainer) {
            this.changeSliderValue(mouseX);
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.method_25367()) {
            super.method_25354(class_310.method_1551().method_1483());
        }
        if (this.isInContainer) {
            this.dragging = false;
        }
    }

    protected void method_25353(class_4587 poseStack, class_310 minecraft, int mouseX, int mouseY) {
        if (this.isInContainer && this.field_22764 && this.dragging) {
            this.changeSliderValue(mouseX);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float direction = flag ? -1.0f : 1.0f;
            this.setSliderValue(this.value + (double)(direction / (float)(this.field_22758 - 8)));
        }
        return false;
    }

    public void method_25354(class_1144 handler) {
    }

    protected void changeSliderValue(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.field_22760 + 4)) / (double)(this.field_22758 - 8));
    }

    protected void setSliderValue(double newValue) {
        double oldValue = this.value;
        this.value = class_3532.method_15350((double)newValue, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            this.updateSlider();
        }
    }
}

