/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.gui.elements.ScalableText;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ScrollingText
extends ScalableText {
    protected int width = 100;
    protected float stepSize = 1.0f;
    protected int speedTime = 20;
    protected int waitTime = 4000;
    protected float moveDifference = 0.0f;
    protected long lastTime = 0L;
    protected State state = State.WAITING;

    public ScrollingText(class_327 font, Supplier<String> textSupplier, float x, float y) {
        super(font, textSupplier, x, y);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public int getSpeedTime() {
        return this.speedTime;
    }

    public void setSpeedTime(int speedtime) {
        this.speedTime = speedtime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public void copyState(ScrollingText renderer) {
        this.setText((String)this.textSupplier.get());
        this.state = renderer.state;
        this.moveDifference = renderer.moveDifference;
        this.lastTime = renderer.lastTime;
    }

    @Override
    protected void updatedText() {
        this.state = State.WAITING;
        this.moveDifference = 0.0f;
        this.lastTime = 0L;
        super.updatedText();
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        Matrix4f matrix = poseStack.method_23760().method_23761();
        double scaleFactor = window.method_4495();
        Vector4f vectorXY = new Vector4f(this.x, this.y, 0.0f, 1.0f);
        vectorXY.mul((Matrix4fc)matrix);
        float f = (float)this.width * matrix.m00();
        Objects.requireNonNull(this.font);
        Vector4f vectorWH = new Vector4f(f, (float)(9 + 1) * this.scale * matrix.m11(), 0.0f, 1.0f);
        int nativeX = class_3532.method_15384((double)((double)vectorXY.x() * scaleFactor));
        int nativeY = class_3532.method_15384((double)((double)vectorXY.y() * scaleFactor));
        int nativeWidth = class_3532.method_15384((double)((double)vectorWH.x() * scaleFactor));
        int nativeHeight = class_3532.method_15384((double)((double)vectorWH.y() * scaleFactor));
        RenderSystem.enableScissor((int)nativeX, (int)(window.method_4507() - (nativeY + nativeHeight)), (int)nativeWidth, (int)nativeHeight);
        this.setText((String)this.textSupplier.get());
        this.renderFont(poseStack, this.font, this.getMovingX(this.x), this.y + 2.0f * this.scale);
        RenderSystem.disableScissor();
    }

    protected float getMovingX(float x) {
        float textWidth = this.getTextWidth();
        if ((float)this.width < textWidth) {
            float maxMove = (float)this.width - textWidth;
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            if (this.state == State.WAITING) {
                if (this.hasWaitTimePassed()) {
                    this.state = this.moveDifference >= 0.0f ? State.LEFT : State.RIGHT;
                    this.lastTime = 0L;
                }
            } else if (this.hasSpeedTimePassed()) {
                if (this.state == State.LEFT ? this.moveDifference >= maxMove : this.moveDifference <= 0.0f) {
                    this.moveDifference += this.state == State.LEFT ? -this.stepSize : this.stepSize;
                } else {
                    this.state = State.WAITING;
                }
                this.lastTime = 0L;
            }
            return x + this.moveDifference;
        }
        return x;
    }

    protected boolean hasWaitTimePassed() {
        return System.currentTimeMillis() - (long)this.waitTime >= this.lastTime;
    }

    protected boolean hasSpeedTimePassed() {
        return System.currentTimeMillis() - (long)this.speedTime >= this.lastTime;
    }

    private static enum State {
        WAITING,
        LEFT,
        RIGHT;

    }
}

