/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.util.RGBA;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_327;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class ScalableText
implements class_4068,
Scalable {
    protected static final Consumer<ScalableText> EMPTY_TEXT_CHANGED = renderer -> {};
    protected final class_327 font;
    protected Supplier<String> textSupplier;
    protected float x;
    protected float y;
    private String text;
    private int textWidth;
    protected RGBA color;
    protected boolean shadow;
    protected float scale;
    private float positionFactor;
    protected Consumer<ScalableText> textChanged;

    public ScalableText(class_327 font, Supplier<String> textSupplier, float x, float y) {
        this.font = font;
        this.textSupplier = textSupplier;
        this.x = x;
        this.y = y;
        this.textWidth = -1;
        this.color = RGBA.WHITE;
        this.scale = 1.0f;
        this.positionFactor = 1.0f;
        this.textChanged = EMPTY_TEXT_CHANGED;
    }

    public void setTextSupplier(Supplier<String> textSupplier) {
        Objects.requireNonNull(textSupplier);
        this.textSupplier = textSupplier;
    }

    public Supplier<String> getTextSupplier() {
        return this.textSupplier;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public RGBA getColor() {
        return this.color;
    }

    public void setColor(RGBA color) {
        this.color = color;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
        this.positionFactor = 1.0f / scale;
    }

    public void setTextChanged(Consumer<ScalableText> textChanged) {
        this.textChanged = textChanged;
    }

    public float getTextWidth() {
        if (this.textWidth == -1) {
            this.setText(this.textSupplier.get());
        }
        return (float)this.textWidth * this.scale;
    }

    protected void setText(String newText) {
        if (newText != null && !newText.equals(this.text) || newText == null && this.text != null) {
            this.text = newText;
            this.textWidth = this.font.method_1727(newText);
            this.updatedText();
        }
    }

    protected void updatedText() {
        this.textChanged.accept(this);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.setText(this.textSupplier.get());
        this.renderFont(poseStack, this.font, this.x, this.y);
    }

    protected void renderFont(class_4587 poseStack, class_327 font, float x, float y) {
        poseStack.method_22903();
        poseStack.method_22905(this.scale, this.scale, 0.0f);
        font.method_27520(this.text, x * this.positionFactor, y * this.positionFactor, this.color.getColorARGB(), poseStack.method_23760().method_23761(), this.shadow, font.method_1726());
        poseStack.method_22909();
    }
}

