/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.gui.elements.UEditBox;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class ScalableEditBox
extends UEditBox
implements Scalable,
ScaleProvider {
    protected float scale;

    public ScalableEditBox(class_327 font, int x, int y, int width, int height, UEditBox previousEditBox, class_2561 title, float scale) {
        super(font, x, y, width, height, previousEditBox, title);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        float currentScale = this.getCurrentScale(poseStack, mouseX, mouseY, partialTicks);
        float positionFactor = 1.0f / this.scale;
        poseStack.method_22903();
        poseStack.method_22905(currentScale, currentScale, 0.0f);
        RGBA currentTextColor = this.getCurrentTextColor(poseStack, mouseX, mouseY, partialTicks);
        String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), this.method_1859());
        int cursorOffset = this.field_2102 - this.field_2103;
        int selectionOffset = Math.min(this.field_2101 - this.field_2103, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.method_25370() && this.field_2107 / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.field_2102 < this.field_2092.length() || this.field_2092.length() >= this.field_2108;
        int xOffset = (int)((float)(this.field_2095 ? this.field_22760 + 4 : this.field_22760) * positionFactor);
        int yOffset = (int)((float)(this.field_2095 ? this.field_22761 + (int)((float)this.field_22759 - 8.0f * this.scale) / 2 : this.field_22761) * positionFactor);
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = this.field_2105.method_27517(poseStack, (class_5481)this.field_2099.apply(firstTextPart, this.field_2103), (float)xOffset, (float)yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.field_22758 : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            this.field_2105.method_27517(poseStack, (class_5481)this.field_2099.apply(currentText.substring(cursorOffset), this.field_2102), (float)leftRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
        }
        if (!isCursorInTheMiddle && this.field_2106 != null) {
            this.field_2105.method_1720(poseStack, this.field_2106, (float)(rightRenderedTextX - 1), (float)yOffset, this.getCurrentSuggestionTextColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                class_332.method_25294((class_4587)poseStack, (int)rightRenderedTextX, (int)(yOffset - 1), (int)(rightRenderedTextX + 1), (int)(yOffset + 1 + 9), (int)this.getCurrentCursorColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB());
            } else {
                this.field_2105.method_1720(poseStack, "_", (float)rightRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.field_2105.method_1727(currentText.substring(0, selectionOffset));
            this.method_1886((int)((float)rightRenderedTextX * currentScale), (int)((float)(yOffset - 1) * currentScale), (int)((float)(selectedX - 1) * currentScale), (int)((float)(yOffset + 1 + 9) * currentScale));
        }
        poseStack.method_22909();
    }

    @Override
    public float getCurrentScale(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.getCurrentScale(mouseX, mouseY);
    }

    public float getCurrentScale(double mouseX, double mouseY) {
        return this.scale;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) {
            return false;
        }
        boolean clicked = this.method_25361(mouseX, mouseY);
        if (this.field_2096) {
            this.method_1876(clicked);
        }
        if (this.method_25370() && clicked && button == 0) {
            int clickOffset = class_3532.method_15357((double)mouseX) - this.field_22760;
            if (this.field_2095) {
                clickOffset -= 4;
            }
            clickOffset = (int)((float)clickOffset / this.getCurrentScale(mouseX, mouseY));
            String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), this.method_1859());
            this.method_1883(this.field_2105.method_27523(currentText, clickOffset).length() + this.field_2103);
            return true;
        }
        return false;
    }
}

