/*
 * Decompiled with CFR 0.152.
 */
package name.uwu.feytox.toomanyplayers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import name.uwu.feytox.toomanyplayers.OnlineWhitelist;
import name.uwu.feytox.toomanyplayers.TMPConfig;
import net.fabricmc.loader.api.FabricLoader;

public class Presets {
    public static List<String> getPresets(boolean withDefault) {
        String[] configs = FabricLoader.getInstance().getConfigDir().toFile().list((dir, name) -> name.toLowerCase().startsWith("tmp_"));
        ArrayList<String> result = new ArrayList<String>();
        if (configs != null) {
            for (String configName : configs) {
                result.add(configName.replace("tmp_", "").replace(".json", ""));
            }
        }
        if (withDefault) {
            result.addAll(Arrays.asList("default", "SP", "SP_potato"));
        }
        return result;
    }

    public static void createPreset(String presetName) {
        Path config = FabricLoader.getInstance().getConfigDir().resolve("toomanyplayers.json");
        Path preset = FabricLoader.getInstance().getConfigDir().resolve("tmp_" + presetName + ".json");
        try {
            Files.copy(config, preset, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setPreset(String presetName) {
        List<String> presets = Presets.getPresets(false);
        for (String preset : presets) {
            if (!preset.equals(presetName)) continue;
            Presets.replaceCfgFile(preset);
            TMPConfig.init();
            return;
        }
        switch (presetName) {
            case "default": {
                Presets.defaultCfg();
                break;
            }
            case "SP_potato": {
                Presets.spPotatoCfg();
                break;
            }
            case "SP": {
                Presets.spCfg();
            }
        }
        TMPConfig.save();
    }

    public static boolean removePreset(String presetName) {
        File preset = FabricLoader.getInstance().getConfigDir().resolve("tmp_" + presetName + ".json").toFile();
        return preset.delete();
    }

    private static void defaultCfg() {
        TMPConfig.toggleMod = false;
        TMPConfig.saveToMemory = TMPConfig.savingTypes.ALL;
        TMPConfig.toggleAreas = true;
        TMPConfig.firstRadius = 5.0;
        TMPConfig.secondRadius = 10.0;
        TMPConfig.areasHideArmor = true;
        TMPConfig.areasHide2ndLayer = false;
        TMPConfig.thirdRadius = 15.0;
        TMPConfig.areasShowOnlyHeads = true;
        TMPConfig.areasHideHeldItems = true;
        TMPConfig.areasHidePlayers = true;
        TMPConfig.whitelist = new ArrayList<String>();
        TMPConfig.blocklist = new ArrayList<String>();
        TMPConfig.blockingType = TMPConfig.BlockingType.ALL;
        TMPConfig.hideskinlist = new ArrayList<String>();
        TMPConfig.hidePlayers = false;
        TMPConfig.hidePlayersdistance = 10.0;
        TMPConfig.showOnlyHeads = false;
        TMPConfig.hideArmor = false;
        TMPConfig.hideHeldItems = false;
        TMPConfig.hideGlint = false;
        TMPConfig.hide2ndLayer = false;
        TMPConfig.toggleOnlineWhitelist = false;
        TMPConfig.onlineWhitelistUrl = "http://tmp-sp-whitelist.uwu.name";
    }

    private static void spCfg() {
        Presets.spPotatoCfg();
        TMPConfig.areasHidePlayers = false;
        TMPConfig.areasHideHeldItems = false;
    }

    private static void spPotatoCfg() {
        Presets.defaultCfg();
        TMPConfig.toggleOnlineWhitelist = true;
        OnlineWhitelist.reloadWhitelist();
    }

    private static void replaceCfgFile(String preset) {
        Path new_config = FabricLoader.getInstance().getConfigDir().resolve("tmp_" + preset + ".json");
        Path old_config = FabricLoader.getInstance().getConfigDir().resolve("toomanyplayers.json");
        try {
            Files.copy(new_config, old_config, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

