/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.AdminCommand;
import com.nettakrim.spyglass_astronomy.commands.HideCommand;
import com.nettakrim.spyglass_astronomy.commands.InfoCommand;
import com.nettakrim.spyglass_astronomy.commands.NameCommand;
import com.nettakrim.spyglass_astronomy.commands.SelectCommand;
import com.nettakrim.spyglass_astronomy.commands.ShareCommand;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2196;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class SpyglassAstronomyCommands {
    public static SuggestionProvider<FabricClientCommandSource> constellations = (context, builder) -> {
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            builder.suggest(constellation.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };
    public static SuggestionProvider<FabricClientCommandSource> stars = (context, builder) -> {
        for (Star star : SpyglassAstronomyClient.stars) {
            if (star.name == null) continue;
            builder.suggest(star.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };
    public static SuggestionProvider<FabricClientCommandSource> orbitingBodies = (context, builder) -> {
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (orbitingBody.name == null) continue;
            builder.suggest(orbitingBody.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public static void initialize() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            RootCommandNode root = dispatcher.getRoot();
            SpyglassAstronomyCommands.registerInfoNode((RootCommandNode<FabricClientCommandSource>)root);
            SpyglassAstronomyCommands.registerSelectNode((RootCommandNode<FabricClientCommandSource>)root);
            SpyglassAstronomyCommands.registerNameNode((RootCommandNode<FabricClientCommandSource>)root);
            SpyglassAstronomyCommands.registerShareNode((RootCommandNode<FabricClientCommandSource>)root);
            SpyglassAstronomyCommands.registerAdminNode((RootCommandNode<FabricClientCommandSource>)root);
            SpyglassAstronomyCommands.registerHideNode((RootCommandNode<FabricClientCommandSource>)root);
        });
    }

    public static void registerInfoNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode infoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:info").executes((Command)new InfoCommand())).build();
        LiteralCommandNode constellationInfoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(constellations).executes(InfoCommand::getConstellationInfo))).build();
        LiteralCommandNode starInfoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(stars).executes(InfoCommand::getStarInfo))).build();
        LiteralCommandNode orbitingBodyInfoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(orbitingBodies).executes(InfoCommand::getOrbitingBodyInfo))).build();
        LiteralCommandNode earthInfoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"thisworld").executes(InfoCommand::getEarthInfo)).build();
        LiteralCommandNode solarSystemInfoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"solarsystem").executes(InfoCommand::getSolarSystemInfo)).build();
        root.addChild((CommandNode)infoNode);
        infoNode.addChild((CommandNode)constellationInfoNode);
        infoNode.addChild((CommandNode)starInfoNode);
        infoNode.addChild((CommandNode)orbitingBodyInfoNode);
        infoNode.addChild((CommandNode)earthInfoNode);
        infoNode.addChild((CommandNode)solarSystemInfoNode);
    }

    public static void registerSelectNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode selectNode = ClientCommandManager.literal((String)"sga:select").build();
        LiteralCommandNode constellationSelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(constellations).executes(SelectCommand::selectConstellation))).build();
        LiteralCommandNode starSelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(stars).executes(SelectCommand::selectStar))).build();
        LiteralCommandNode orbitingBodySelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(orbitingBodies).executes(SelectCommand::selectOrbitingBody))).build();
        root.addChild((CommandNode)selectNode);
        selectNode.addChild((CommandNode)constellationSelectNode);
        selectNode.addChild((CommandNode)starSelectNode);
        selectNode.addChild((CommandNode)orbitingBodySelectNode);
    }

    public static void registerNameNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode nameNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:name").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).executes((Command)new NameCommand()))).build();
        root.addChild((CommandNode)nameNode);
    }

    public static void registerShareNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode shareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:share").executes((Command)new ShareCommand())).build();
        LiteralCommandNode constellationShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(constellations).executes(ShareCommand::shareConstellation))).build();
        LiteralCommandNode starShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(stars).executes(ShareCommand::shareStar))).build();
        LiteralCommandNode orbitingBodyShareNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(orbitingBodies).executes(ShareCommand::shareOrbitingBody))).build();
        root.addChild((CommandNode)shareNode);
        shareNode.addChild((CommandNode)constellationShareNode);
        shareNode.addChild((CommandNode)starShareNode);
        shareNode.addChild((CommandNode)orbitingBodyShareNode);
    }

    public static void registerAdminNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode adminNode = ClientCommandManager.literal((String)"sga:admin").build();
        LiteralCommandNode removeNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"removeconstellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(constellations).executes(AdminCommand::removeConstellation))).build();
        LiteralCommandNode setStarCountNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setstarcount").then(ClientCommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(AdminCommand::setStarCount))).build();
        LiteralCommandNode bypassNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bypassknowledge").executes(AdminCommand::bypassKnowledge)).build();
        LiteralCommandNode yearLengthNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setyearlength").then(ClientCommandManager.argument((String)"days", (ArgumentType)FloatArgumentType.floatArg((float)0.125f)).executes(AdminCommand::setYearLength))).build();
        root.addChild((CommandNode)adminNode);
        adminNode.addChild((CommandNode)removeNode);
        adminNode.addChild((CommandNode)setStarCountNode);
        adminNode.addChild((CommandNode)bypassNode);
        adminNode.addChild((CommandNode)yearLengthNode);
        SpyglassAstronomyCommands.registerAdminAddNode((LiteralCommandNode<FabricClientCommandSource>)adminNode);
        SpyglassAstronomyCommands.registerAdminSetSeedNode((LiteralCommandNode<FabricClientCommandSource>)adminNode);
        SpyglassAstronomyCommands.registerAdminRenameNode((LiteralCommandNode<FabricClientCommandSource>)adminNode);
        SpyglassAstronomyCommands.registerAdminChangesNode((LiteralCommandNode<FabricClientCommandSource>)adminNode);
    }

    public static void registerAdminAddNode(LiteralCommandNode<FabricClientCommandSource> node) {
        LiteralCommandNode addNode = ClientCommandManager.literal((String)"add").build();
        LiteralCommandNode addConstellationNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"data", (ArgumentType)class_2196.method_9340()).executes(AdminCommand::addConstellation))).build();
        node.addChild((CommandNode)addNode);
        addNode.addChild((CommandNode)addConstellationNode);
    }

    public static void registerAdminSetSeedNode(LiteralCommandNode<FabricClientCommandSource> node) {
        LiteralCommandNode setSeedNode = ClientCommandManager.literal((String)"setseed").build();
        LiteralCommandNode setStarSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(AdminCommand::setStarSeed))).build();
        LiteralCommandNode setPlanetSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(AdminCommand::setPlanetSeed))).build();
        node.addChild((CommandNode)setSeedNode);
        setSeedNode.addChild((CommandNode)setStarSeedNode);
        setSeedNode.addChild((CommandNode)setPlanetSeedNode);
    }

    public static void registerAdminRenameNode(LiteralCommandNode<FabricClientCommandSource> node) {
        LiteralCommandNode renameNode = ClientCommandManager.literal((String)"rename").build();
        LiteralCommandNode constellationNameNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).executes(NameCommand::nameConstellation)))).build();
        LiteralCommandNode starNameNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).executes(NameCommand::nameStar)))).build();
        LiteralCommandNode orbitingBodyNameNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).executes(NameCommand::nameOrbitingBody)))).build();
        node.addChild((CommandNode)renameNode);
        renameNode.addChild((CommandNode)constellationNameNode);
        renameNode.addChild((CommandNode)starNameNode);
        renameNode.addChild((CommandNode)orbitingBodyNameNode);
    }

    public static void registerAdminChangesNode(LiteralCommandNode<FabricClientCommandSource> node) {
        LiteralCommandNode changesNode = ClientCommandManager.literal((String)"changes").build();
        LiteralCommandNode discardNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"discard").executes(AdminCommand::discardUnsavedChanges)).build();
        LiteralCommandNode saveNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"save").executes(AdminCommand::saveChanges)).build();
        LiteralCommandNode queryNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"query").executes(AdminCommand::queryChanges)).build();
        node.addChild((CommandNode)changesNode);
        changesNode.addChild((CommandNode)discardNode);
        changesNode.addChild((CommandNode)saveNode);
        changesNode.addChild((CommandNode)queryNode);
    }

    public static void registerHideNode(RootCommandNode<FabricClientCommandSource> root) {
        LiteralCommandNode hideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:hide").executes((Command)new HideCommand())).build();
        LiteralCommandNode constellationsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellations").executes(HideCommand::hideConstellations)).build();
        LiteralCommandNode starsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stars").executes(HideCommand::hideStars)).build();
        LiteralCommandNode orbitingBodiesHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planets").executes(HideCommand::hideOrbitingBodies)).build();
        LiteralCommandNode oldStarsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vanillastars").executes(HideCommand::hideOldStars)).build();
        root.addChild((CommandNode)hideNode);
        hideNode.addChild((CommandNode)constellationsHideNode);
        hideNode.addChild((CommandNode)starsHideNode);
        hideNode.addChild((CommandNode)orbitingBodiesHideNode);
        hideNode.addChild((CommandNode)oldStarsHideNode);
    }

    public static Constellation getConstellation(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            if (!constellation.name.equals(name)) continue;
            return constellation;
        }
        SpyglassAstronomyClient.say("commands.find.constellation.fail", name);
        return null;
    }

    public static Star getStar(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (Star star : SpyglassAstronomyClient.stars) {
            if (star.name == null || !star.name.equals(name)) continue;
            return star;
        }
        SpyglassAstronomyClient.say("commands.find.star.fail", name);
        return null;
    }

    public static OrbitingBody getOrbitingBody(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (orbitingBody.name == null || !orbitingBody.name.equals(name)) continue;
            return orbitingBody;
        }
        SpyglassAstronomyClient.say("commands.find.planet.fail", name);
        return null;
    }

    public static String getMessageText(CommandContext<FabricClientCommandSource> context) {
        return SpyglassAstronomyCommands.getMessageText(context, "name");
    }

    public static String getMessageText(CommandContext<FabricClientCommandSource> context, String name) {
        class_2196.class_2197 messageFormat = (class_2196.class_2197)context.getArgument(name, class_2196.class_2197.class);
        return messageFormat.method_35691();
    }

    public static class_2561 getClickHere(String actionKey, String command, boolean run, Object ... formatting) {
        return class_2561.method_43471((String)"spyglass_astronomy.commands.share.click").method_10862(class_2583.field_24360.method_10958(new class_2558(run ? class_2558.class_2559.field_11750 : class_2558.class_2559.field_11745, command)).method_10977(class_124.field_1060)).method_10852((class_2561)class_2561.method_43469((String)("spyglass_astronomy." + actionKey), (Object[])formatting).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
    }
}

