/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class ShareCommand
implements Command<FabricClientCommandSource> {
    public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        if (Constellation.selected != null) {
            ShareCommand.share(Constellation.selected);
            return 1;
        }
        if (Star.selected != null) {
            ShareCommand.share(Star.selected);
            return 1;
        }
        if (OrbitingBody.selected != null) {
            ShareCommand.share(OrbitingBody.selected);
            return 1;
        }
        SpyglassAstronomyClient.say("commands.share.nothingselected", new Object[0]);
        return -1;
    }

    public static int shareConstellation(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = SpyglassAstronomyCommands.getConstellation(context);
        if (constellation == null) {
            return -1;
        }
        ShareCommand.share(constellation);
        return 1;
    }

    public static int shareStar(CommandContext<FabricClientCommandSource> context) {
        Star star = SpyglassAstronomyCommands.getStar(context);
        if (star == null) {
            return -1;
        }
        ShareCommand.share(star);
        return 1;
    }

    public static int shareOrbitingBody(CommandContext<FabricClientCommandSource> context) {
        OrbitingBody orbitingBody = SpyglassAstronomyCommands.getOrbitingBody(context);
        if (orbitingBody == null) {
            return -1;
        }
        ShareCommand.share(orbitingBody);
        return 1;
    }

    public static void share(Constellation constellation) {
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share.constellation", "sga:c_" + SpaceDataManager.encodeConstellation(null, constellation).replace(" | ", "|") + "|", false, constellation.name);
        SpyglassAstronomyClient.sayText(text);
    }

    public static void share(Star star) {
        String starName = star.name == null ? "Unnamed" : star.name;
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share.star", "sga:s_" + starName + "|" + Integer.toString(star.index) + "|", false, starName);
        SpyglassAstronomyClient.sayText(text);
    }

    public static void share(OrbitingBody orbitingBody) {
        String orbitingBodyName = orbitingBody.name == null ? "Unnamed" : orbitingBody.name;
        class_2561 text = SpyglassAstronomyCommands.getClickHere("commands.share." + (orbitingBody.isPlanet ? "planet" : "comet"), "sga:p_" + orbitingBodyName + "|" + Integer.toString(SpyglassAstronomyClient.orbitingBodies.indexOf(orbitingBody)) + "|", false, orbitingBodyName);
        SpyglassAstronomyClient.sayText(text);
    }
}

