/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.Knowledge;
import com.nettakrim.spyglass_astronomy.Orbit;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InfoCommand
implements Command<FabricClientCommandSource> {
    public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        if (Constellation.selected != null) {
            InfoCommand.displayInfo(Constellation.selected);
            return 1;
        }
        if (Star.selected != null) {
            InfoCommand.displayInfo(Star.selected);
            return 1;
        }
        if (OrbitingBody.selected != null) {
            InfoCommand.displayInfo(OrbitingBody.selected);
            return 1;
        }
        SpyglassAstronomyClient.say("commands.info.nothingselected", new Object[0]);
        return -1;
    }

    public static int getConstellationInfo(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = SpyglassAstronomyCommands.getConstellation(context);
        if (constellation == null) {
            return -1;
        }
        InfoCommand.displayInfo(constellation);
        return 1;
    }

    public static int getStarInfo(CommandContext<FabricClientCommandSource> context) {
        Star star = SpyglassAstronomyCommands.getStar(context);
        if (star == null) {
            return -1;
        }
        InfoCommand.displayInfo(star);
        return 1;
    }

    public static int getOrbitingBodyInfo(CommandContext<FabricClientCommandSource> context) {
        OrbitingBody orbitingBody = SpyglassAstronomyCommands.getOrbitingBody(context);
        if (orbitingBody == null) {
            return -1;
        }
        InfoCommand.displayInfo(orbitingBody);
        return 1;
    }

    public static int getEarthInfo(CommandContext<FabricClientCommandSource> context) {
        InfoCommand.displayEarthInfo();
        return 1;
    }

    public static int getSolarSystemInfo(CommandContext<FabricClientCommandSource> context) {
        InfoCommand.displaySolarSystemInfo();
        return 1;
    }

    private static void displayInfo(Constellation constellation) {
        int[] flags = new int[]{-1, -1};
        class_5250 text = class_2561.method_43473();
        text.method_10852(InfoCommand.translate("constellation.name", constellation.name));
        Vector3f position = constellation.getAveragePosition();
        InfoCommand.staticVisibilityInfo(text, position, flags);
        text.method_10852(SpyglassAstronomyClient.knowledge.getKnowledgeInstructions(flags));
        SpyglassAstronomyClient.longSay((class_2561)text);
    }

    private static void displayInfo(Star star) {
        int[] flags = new int[]{-1, -1};
        class_5250 text = class_2561.method_43473();
        text.method_10852(InfoCommand.translate("star.name", star.name == null ? "Unnamed" : star.name));
        Vector3f position = star.getPositionAsVector3f();
        InfoCommand.staticVisibilityInfo(text, position, flags);
        if (SpyglassAstronomyClient.knowledge.starKnowledgeAtleast(Knowledge.Level.MASTER, flags)) {
            float alpha = star.getAlpha();
            int distance = (int)((1.0f - alpha) * 1000.0f);
            if ((distance += star.index % 100) < 1) {
                distance = 1;
            }
            text.method_10852(InfoCommand.translate("star.distance", Integer.toString(distance)));
        }
        text.method_10852(SpyglassAstronomyClient.knowledge.getKnowledgeInstructions(flags));
        SpyglassAstronomyClient.longSay((class_2561)text);
    }

    private static void displayInfo(OrbitingBody orbitingBody) {
        int[] flags = new int[]{-1, -1};
        class_5250 text = class_2561.method_43473();
        text.method_10852(InfoCommand.translate("planet.name", orbitingBody.name == null ? "Unnamed" : orbitingBody.name));
        text.method_10852(InfoCommand.translate("planet.type." + orbitingBody.type.toString().toLowerCase(), new Object[0]));
        InfoCommand.orbitInfo(text, orbitingBody.orbit, flags);
        text.method_10852(SpyglassAstronomyClient.knowledge.getKnowledgeInstructions(flags));
        SpyglassAstronomyClient.longSay((class_2561)text);
    }

    private static void displayEarthInfo() {
        int[] flags = new int[]{-1, -1};
        class_5250 text = class_2561.method_43473();
        text.method_10852(InfoCommand.translate("thisworld.time", InfoCommand.getMinecraftTime()));
        text.method_10852(InfoCommand.translate("thisworld.moonphase", new Object[0])).method_10852(InfoCommand.translate("moonphase." + Integer.toString(SpyglassAstronomyClient.world.method_30273(), 1), new Object[0]));
        InfoCommand.orbitInfo(text, SpyglassAstronomyClient.earthOrbit, flags);
        text.method_10852(SpyglassAstronomyClient.knowledge.getKnowledgeInstructions(flags));
        SpyglassAstronomyClient.longSay((class_2561)text);
    }

    private static void displaySolarSystemInfo() {
        int[] flags = new int[]{-1, -1};
        class_5250 text = class_2561.method_43473();
        text.method_10852(InfoCommand.translate("solarsystem.planets", new Object[0]));
        int stage = 0;
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (stage == 0 && orbitingBody.orbit.period > SpyglassAstronomyClient.earthOrbit.period) {
                text.method_10852(InfoCommand.translate("solarsystem.thisworld", new Object[0]));
                stage = 1;
            }
            if (stage == 1 && !orbitingBody.isPlanet) {
                if (!SpyglassAstronomyClient.knowledge.orbitKnowledgeAtleast(Knowledge.Level.ADEPT, flags)) break;
                text.method_10852(InfoCommand.translate("solarsystem.comets", new Object[0]));
                stage = 2;
            }
            if (orbitingBody.name == null) {
                text.method_10852(InfoCommand.translate("solarsystem.unknown", new Object[0]));
                continue;
            }
            text.method_10852(InfoCommand.translate("solarsystem.named", orbitingBody.name));
        }
        if (SpyglassAstronomyClient.knowledge.orbitKnowledgeAtleast(Knowledge.Level.EXPERT, flags)) {
            text.method_10852(InfoCommand.translate("solarsystem.time", Long.toString(SpyglassAstronomyClient.getDay()), Float.toString(Math.round(SpyglassAstronomyClient.getDayFraction() * 100.0f) / 100).replace("0.", "")));
        }
        text.method_10852(SpyglassAstronomyClient.knowledge.getKnowledgeInstructions(flags));
        SpyglassAstronomyClient.longSay((class_2561)text);
    }

    private static void staticVisibilityInfo(class_5250 text, Vector3f position, int[] flags) {
        Vector3f pos = new Vector3f((Vector3fc)position);
        pos.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
        pos.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.getStarAngle()));
        pos.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        float yaw = (float)(Math.atan2(pos.x, pos.z) * -180.0 / Math.PI);
        float angle = (float)(Math.atan2(Math.sqrt(pos.x * pos.x + pos.z * pos.z), pos.y) * 180.0 / Math.PI) - 90.0f;
        text.method_10852(InfoCommand.translate("visibility.angle", InfoCommand.prettyFloat(yaw), InfoCommand.prettyFloat(angle)));
        if (SpyglassAstronomyClient.knowledge.starKnowledgeAtleast(Knowledge.Level.ADEPT, flags)) {
            pos = new Vector3f((Vector3fc)position);
            pos.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
            pos.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.starAngleMultiplier * (0.75f / SpyglassAstronomyClient.earthOrbit.period)));
            pos.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            if (class_3532.method_15379((float)pos.z) < 0.9f) {
                float referenceYaw = (float)(Math.atan2(pos.x, pos.z) * -180.0 / Math.PI);
                angle = (float)(Math.atan2(Math.sqrt(pos.x * pos.x + pos.z * pos.z), pos.y) * 180.0 / Math.PI) - 90.0f;
                if (referenceYaw < 0.0f) {
                    angle = 180.0f - angle;
                }
                if (angle < 0.0f) {
                    angle += 360.0f;
                }
                float period = SpyglassAstronomyClient.earthOrbit.period;
                angle = (period - (float)class_3532.method_15375((float)(angle / 360.0f * period + 0.5f))) % period;
                int nearestDay = (int)angle;
                if (period == 8.0f) {
                    text.method_10852(InfoCommand.translate("visibility.time.moonphase", new Object[0])).method_10852(InfoCommand.translate("moonphase." + Integer.toString(nearestDay), new Object[0]));
                } else {
                    int inDays = nearestDay - (int)(SpyglassAstronomyClient.getDay() % (long)period);
                    if (inDays < 0) {
                        inDays += 8;
                    }
                    text.method_10852(InfoCommand.translate("visibility.time.date", nearestDay, inDays));
                }
            } else {
                text.method_10852(InfoCommand.translate("visibility.time.always", new Object[0]));
            }
        }
    }

    private static void orbitInfo(class_5250 text, Orbit orbit, int[] flags) {
        boolean isEarth;
        if (SpyglassAstronomyClient.knowledge.starKnowledgeAtleast(Knowledge.Level.NOVICE, flags)) {
            text.method_10852(InfoCommand.translate("orbit.period", InfoCommand.prettyFloat(orbit.period)));
        }
        boolean bl = isEarth = orbit == SpyglassAstronomyClient.earthOrbit;
        if (!isEarth && SpyglassAstronomyClient.knowledge.starKnowledgeAtleast(Knowledge.Level.ADEPT, flags)) {
            float max = Math.max(orbit.period, SpyglassAstronomyClient.earthOrbit.period);
            float min = Math.min(orbit.period, SpyglassAstronomyClient.earthOrbit.period);
            double[] fraction = InfoCommand.getFraction(max / min);
            float resonance = (float)fraction[1] * max / (float)(fraction[0] - fraction[1]);
            text.method_10852(InfoCommand.translate("orbit.resonance", InfoCommand.prettyFloat(resonance)));
        }
        if (isEarth && SpyglassAstronomyClient.knowledge.starKnowledgeAtleast(Knowledge.Level.ADEPT, flags) || SpyglassAstronomyClient.knowledge.orbitKnowledgeAtleast(Knowledge.Level.EXPERT, flags)) {
            text.method_10852(InfoCommand.translate("orbit.position", Integer.toString((int)(orbit.lastLocalTime * 100.0f))));
        }
        if (!isEarth && SpyglassAstronomyClient.knowledge.orbitKnowledgeAtleast(Knowledge.Level.EXPERT, flags)) {
            Vector3f pos = orbit.getLastRotatedPosition();
            Vector3f earthPos = SpyglassAstronomyClient.earthOrbit.getLastRotatedPosition();
            pos.sub((Vector3fc)earthPos);
            float sqrDistance = SpyglassAstronomyClient.getSquaredDistance(pos.x, pos.y, pos.z);
            text.method_10852(InfoCommand.translate("orbit.distance", InfoCommand.prettyFloat(class_3532.method_15355((float)sqrDistance) / SpyglassAstronomyClient.earthOrbit.semiMajorAxis)));
            pos.normalize();
            pos.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(SpyglassAstronomyClient.getPositionInOrbit(360.0f) * (1.0f - 1.0f / SpyglassAstronomyClient.earthOrbit.period) + 180.0f));
            float yaw = (float)(Math.atan2(pos.x, pos.z) * -180.0 / Math.PI);
            float angle = (float)(Math.atan2(Math.sqrt(pos.x * pos.x + pos.z * pos.z), pos.y) * 180.0 / Math.PI) - 90.0f;
            text.method_10852(InfoCommand.translate("orbit.angle", InfoCommand.prettyFloat(yaw), InfoCommand.prettyFloat(angle)));
        }
        if (SpyglassAstronomyClient.knowledge.orbitKnowledgeAtleast(Knowledge.Level.MASTER, flags)) {
            text.method_10852(InfoCommand.translate("orbit.eccentricity", InfoCommand.prettyFloat(orbit.eccentricity)));
            text.method_10852(InfoCommand.translate("orbit.inclination", InfoCommand.prettyFloat(orbit.inclination)));
        }
    }

    private static double[] getFraction(double x) {
        double tolerance = 1.0E-6;
        double h1 = 1.0;
        double h2 = 0.0;
        double k1 = 0.0;
        double k2 = 1.0;
        double b = x;
        do {
            double a = Math.floor(b);
            double aux = h1;
            h1 = a * h1 + h2;
            h2 = aux;
            aux = k1;
            k1 = a * k1 + k2;
            k2 = aux;
            b = 1.0 / (b - a);
        } while (Math.abs(x - h1 / k1) > x * tolerance);
        return new double[]{h1, k1};
    }

    private static String prettyFloat(float f) {
        if (f == (float)class_3532.method_15375((float)f)) {
            return Integer.toString((int)f);
        }
        f = Math.round(f * 100.0f);
        return Float.toString(f / 100.0f);
    }

    private static String getMinecraftTime() {
        Long timeDay = SpyglassAstronomyClient.world.method_8532();
        int dayTicks = (int)(timeDay % 24000L);
        int hour = (dayTicks / 1000 + 6) % 24;
        int min = (int)((float)dayTicks / 16.666666f) % 60;
        int sec = (int)((float)dayTicks / 0.277777f) % 60;
        return InfoCommand.formatTime(hour, min, sec);
    }

    private static String formatTime(int hour, int min, int sec) {
        Object time = Integer.toString(sec);
        if (((String)time).length() == 1) {
            time = "0" + (String)time;
        }
        if (((String)(time = Integer.toString(min) + ":" + (String)time)).length() == 4) {
            time = "0" + (String)time;
        }
        if (((String)(time = Integer.toString(hour) + ":" + (String)time)).length() == 7) {
            time = "0" + (String)time;
        }
        return time;
    }

    private static class_2561 translate(String key, Object ... formatting) {
        return class_2561.method_43469((String)("spyglass_astronomy.commands.info." + key), (Object[])formatting);
    }
}

