/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpaceRenderingManager {
    private class_291 starsBuffer = new class_291();
    private class_287 starBufferBuilder = class_289.method_1348().method_1349();
    private class_291 constellationsBuffer = new class_291();
    private class_287 constellationsBufferBuilder = class_289.method_1348().method_1349();
    private boolean constellationsNeedsUpdate = true;
    private class_291 drawingConstellationsBuffer = new class_291();
    private class_287 drawingConstellationsBufferBuilder = class_289.method_1348().method_1349();
    private class_291 planetsBuffer = new class_291();
    private class_287 planetsBufferBuilder = class_289.method_1348().method_1349();
    private static float heightScale = 1.0f;
    public static boolean constellationsVisible;
    public static boolean starsVisible;
    public static boolean orbitingBodiesVisible;
    public static boolean oldStarsVisible;

    public SpaceRenderingManager() {
        constellationsVisible = true;
        starsVisible = true;
        orbitingBodiesVisible = true;
        oldStarsVisible = false;
    }

    public void updateSpace(int ticks) {
        class_746 player;
        SpaceRenderingManager.updateHeightScale();
        if (!(Constellation.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Constellation.deselect();
            this.constellationsNeedsUpdate = true;
        }
        if (this.constellationsNeedsUpdate) {
            this.updateConstellations();
            this.constellationsNeedsUpdate = false;
        }
        if (!(Star.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Star.deselect();
        }
        if (!(OrbitingBody.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            OrbitingBody.deselect();
        }
        this.updateStars(ticks);
        this.updateOrbits(ticks);
    }

    public void scheduleConstellationsUpdate() {
        this.constellationsNeedsUpdate = true;
    }

    private void updateConstellations() {
        this.constellationsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            constellation.setVertices(this.constellationsBufferBuilder, false);
        }
        this.constellationsBuffer.method_1353();
        this.constellationsBuffer.method_1352(this.constellationsBufferBuilder.method_1326());
    }

    private void updateStars(int ticks) {
        this.starBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Star star : SpyglassAstronomyClient.stars) {
            star.update(ticks);
            star.setVertices(this.starBufferBuilder);
        }
        this.starsBuffer.method_1353();
        this.starsBuffer.method_1352(this.starBufferBuilder.method_1326());
    }

    private void updateOrbits(int ticks) {
        this.planetsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Long day = SpyglassAstronomyClient.getDay();
        float dayFraction = SpyglassAstronomyClient.getDayFraction();
        Vector3f referencePosition = SpyglassAstronomyClient.earthOrbit.getRotatedPositionAtGlobalTime(day, dayFraction, true);
        Vector3f normalisedReferencePosition = new Vector3f((Vector3fc)referencePosition);
        normalisedReferencePosition.normalize();
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            orbitingBody.update(ticks, referencePosition, normalisedReferencePosition, day, dayFraction);
            orbitingBody.setVertices(this.constellationsBufferBuilder);
        }
        this.planetsBuffer.method_1353();
        this.planetsBuffer.method_1352(this.planetsBufferBuilder.method_1326());
    }

    private void updateDrawingConstellation() {
        this.drawingConstellationsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        SpyglassAstronomyClient.drawingConstellation.setVertices(this.drawingConstellationsBufferBuilder, true);
        this.drawingConstellationsBuffer.method_1353();
        this.drawingConstellationsBuffer.method_1352(this.drawingConstellationsBufferBuilder.method_1326());
    }

    public void Render(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean bl, Runnable runnable) {
        float starVisibility = SpyglassAstronomyClient.world.method_23787(tickDelta) * (1.0f - SpyglassAstronomyClient.world.method_8430(tickDelta));
        if (starVisibility > 0.0f) {
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.getStarAngle()));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            float colorScale = starVisibility + Math.min(heightScale, 0.5f);
            RenderSystem.setShaderColor((float)colorScale, (float)colorScale, (float)colorScale, (float)starVisibility);
            class_758.method_23792();
            if (starsVisible) {
                this.starsBuffer.method_1353();
                this.starsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                class_291.method_1354();
            }
            if (constellationsVisible) {
                this.constellationsBuffer.method_1353();
                this.constellationsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                class_291.method_1354();
                if (SpyglassAstronomyClient.isDrawingConstellation) {
                    this.updateDrawingConstellation();
                    this.drawingConstellationsBuffer.method_1353();
                    this.drawingConstellationsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                }
            }
            if (orbitingBodiesVisible) {
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40718.rotationDegrees(SpyglassAstronomyClient.getPositionInOrbit(360.0f) * (1.0f - 1.0f / SpyglassAstronomyClient.earthOrbit.period) + 180.0f));
                this.planetsBuffer.method_1353();
                this.planetsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                class_291.method_1354();
            }
            runnable.run();
        }
    }

    public static void updateHeightScale() {
        heightScale = class_3532.method_15363((float)((SpyglassAstronomyClient.getHeight() - 32.0f) / 256.0f), (float)0.0f, (float)1.0f);
    }

    public static float getHeightScale() {
        return heightScale;
    }
}

