/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.StarLine;
import com.nettakrim.spyglass_astronomy.mixin.BiomeAccessAccessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Scanner;
import net.minecraft.class_1132;
import net.minecraft.class_638;
import net.minecraft.class_642;

public class SpaceDataManager {
    public static final int SAVE_FORMAT = 1;
    private long starSeed;
    private long planetSeed;
    private float yearLength;
    private File data = null;
    private Path storagePath = null;
    private String fileName;
    public ArrayList<StarData> starDatas;
    public ArrayList<OrbitingBodyData> orbitingBodyDatas;
    private int changesMade;

    public SpaceDataManager(class_638 world) {
        long seedHash = ((BiomeAccessAccessor)world.method_22385()).getSeed();
        boolean useDefault = true;
        this.storagePath = SpyglassAstronomyClient.client.field_1697.toPath().resolve(".spyglass_astronomy").resolve(SpaceDataManager.getCurrentWorldOrServerName());
        this.fileName = this.storagePath.toString() + "/" + seedHash + ".txt";
        if (Files.exists(this.storagePath, new LinkOption[0])) {
            this.data = new File(this.fileName);
            if (this.data.exists()) {
                boolean bl = useDefault = !this.loadData();
            }
        }
        if (useDefault) {
            this.starSeed = seedHash;
            this.planetSeed = seedHash;
            this.yearLength = 8.0f;
        }
    }

    public boolean loadData() {
        try {
            this.data.createNewFile();
            Scanner scanner = new Scanner(this.data);
            int stage = 0;
            Base64.Decoder decoder = Base64.getDecoder();
            int starIndex = 0;
            this.starDatas = new ArrayList();
            this.orbitingBodyDatas = new ArrayList();
            this.changesMade = 0;
            boolean useDefault = false;
            while (scanner.hasNextLine()) {
                String s = scanner.nextLine();
                if (s.equals("---")) {
                    ++stage;
                    continue;
                }
                switch (stage) {
                    case 0: {
                        int format = Integer.parseInt(s.replace("Spyglass Astronomy - Format: ", ""));
                        if (format != 0) break;
                        useDefault = true;
                        break;
                    }
                    case 1: {
                        String[] seeds = s.split(" ");
                        if (seeds.length == 1) {
                            this.planetSeed = this.starSeed = Long.parseLong(s);
                            break;
                        }
                        this.starSeed = Long.parseLong(seeds[0]);
                        this.planetSeed = Long.parseLong(seeds[1]);
                        break;
                    }
                    case 2: {
                        String[] constellationParts = s.split(" \\| ");
                        SpyglassAstronomyClient.constellations.add(SpaceDataManager.decodeConstellation(decoder, constellationParts[0], constellationParts[1]));
                        break;
                    }
                    case 3: {
                        int starSplit = s.indexOf(32);
                        String starName = s.substring(starSplit + 1);
                        this.starDatas.add(new StarData(starIndex += Integer.parseInt(s.substring(0, starSplit)), starName));
                        break;
                    }
                    case 4: {
                        int orbitingBodySplit = s.indexOf(32);
                        int orbitingBodyIndex = Integer.parseInt(s.substring(0, orbitingBodySplit));
                        String orbitingBodyName = s.substring(orbitingBodySplit + 1);
                        this.orbitingBodyDatas.add(new OrbitingBodyData(orbitingBodyIndex, orbitingBodyName));
                        break;
                    }
                    case 5: {
                        String[] parts = s.split(" ");
                        SpyglassAstronomyClient.setStarCount(Integer.parseInt(parts[0]));
                        if (parts.length > 1) {
                            this.setYearLength(Float.parseFloat(parts[1]));
                            break;
                        }
                        this.yearLength = 8.0f;
                    }
                }
            }
            scanner.close();
            return !useDefault;
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to load data");
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveData() {
        if (this.changesMade == 0) {
            return;
        }
        try {
            if (this.data == null) {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
                this.data = new File(this.fileName);
            }
            FileWriter writer = new FileWriter(this.data);
            StringBuilder s = new StringBuilder("Spyglass Astronomy - Format: 1");
            s.append("\n---\n");
            s.append(this.starSeed);
            if (this.planetSeed != this.starSeed) {
                s.append(' ');
                s.append(this.planetSeed);
            }
            s.append("\n---");
            Base64.Encoder encoder = Base64.getEncoder();
            for (Constellation constellation : SpyglassAstronomyClient.constellations) {
                s.append('\n');
                s.append(SpaceDataManager.encodeConstellation(encoder, constellation));
            }
            s.append("\n---");
            int lastIndex = 0;
            for (Star star : SpyglassAstronomyClient.stars) {
                if (star.name == null) continue;
                s.append('\n');
                s.append(Integer.toString(star.index - lastIndex) + " " + star.name);
                lastIndex = star.index;
            }
            s.append("\n---");
            boolean bl = false;
            for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
                void var5_10;
                if (orbitingBody.name != null) {
                    s.append('\n');
                    s.append(Integer.toString((int)var5_10) + " " + orbitingBody.name);
                }
                ++var5_10;
            }
            s.append("\n---\n");
            s.append(SpyglassAstronomyClient.getStarCount());
            s.append(" ");
            s.append(this.yearLength);
            s.append("\n---");
            writer.write(s.toString());
            writer.close();
            this.changesMade = 0;
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to save data");
        }
    }

    public static String encodeConstellation(Base64.Encoder encoder, Constellation constellation) {
        if (encoder == null) {
            encoder = Base64.getEncoder();
        }
        String encodedConstellation = constellation.name + " | ";
        for (StarLine line : constellation.getLines()) {
            encodedConstellation = encodedConstellation + SpaceDataManager.encodeStarLine(encoder, line.getStars());
        }
        return encodedConstellation;
    }

    private static String encodeStarLine(Base64.Encoder encoder, Star[] stars) {
        int starA = stars[0].index;
        int starB = stars[1].index;
        int combined = starA + (starB << 12);
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(combined);
        byte[] array = bb.array();
        return encoder.encodeToString(array).substring(1, 6);
    }

    public static Constellation decodeConstellation(Base64.Decoder decoder, String name, String lines) {
        if (decoder == null) {
            decoder = Base64.getDecoder();
        }
        Constellation constellation = new Constellation();
        constellation.name = name;
        int continueIf = lines.length() - 5;
        for (int x = 0; x <= continueIf; x += 5) {
            constellation.addLine(SpaceDataManager.decodeStarLine(decoder, lines.substring(x, x + 5)));
        }
        return constellation;
    }

    private static StarLine decodeStarLine(Base64.Decoder decoder, String s) {
        byte[] array = decoder.decode("A" + s + "==");
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(array);
        bb.rewind();
        int combined = bb.getInt();
        int starB = combined >> 12;
        int starA = combined - (starB << 12);
        return new StarLine(starA, starB, false);
    }

    public long getStarSeed() {
        return this.starSeed;
    }

    public long getPlanetSeed() {
        return this.planetSeed;
    }

    public void setStarSeed(long starSeed) {
        this.starSeed = starSeed;
    }

    public void setPlanetSeed(long planetSeed) {
        this.planetSeed = planetSeed;
    }

    public float getYearLength() {
        return this.yearLength;
    }

    public void setYearLength(float yearLength) {
        this.yearLength = yearLength;
    }

    private static String getCurrentWorldOrServerName() {
        class_1132 integratedServer = SpyglassAstronomyClient.client.method_1576();
        if (integratedServer != null) {
            return integratedServer.method_27728().method_150();
        }
        if (SpyglassAstronomyClient.client.method_1589()) {
            return "realms";
        }
        class_642 serverInfo = SpyglassAstronomyClient.client.method_1558();
        if (serverInfo != null) {
            return serverInfo.field_3761.replace(':', '_');
        }
        return "unknown";
    }

    public void loadStarDatas() {
        if (this.starDatas == null) {
            return;
        }
        for (StarData starData : this.starDatas) {
            SpyglassAstronomyClient.stars.get((int)starData.index).name = starData.name;
        }
        this.starDatas = null;
    }

    public void loadOrbitingBodyDatas() {
        if (this.orbitingBodyDatas == null) {
            return;
        }
        for (OrbitingBodyData orbitingBodyData : this.orbitingBodyDatas) {
            SpyglassAstronomyClient.orbitingBodies.get((int)orbitingBodyData.index).name = orbitingBodyData.name;
        }
        this.orbitingBodyDatas = null;
    }

    public static void makeChange() {
        ++SpyglassAstronomyClient.spaceDataManager.changesMade;
        SpyglassAstronomyClient.updateKnowledge();
    }

    public static int getChanges() {
        return SpyglassAstronomyClient.spaceDataManager.changesMade;
    }

    public class StarData {
        public int index;
        public String name;

        public StarData(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }

    public class OrbitingBodyData {
        public int index;
        public String name;

        public OrbitingBodyData(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

