/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.Orbit;
import com.nettakrim.spyglass_astronomy.SpaceRenderingManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import java.util.ArrayList;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OrbitingBody {
    public final Orbit orbit;
    private ArrayList<OrbitingBody> moons;
    private final float size;
    private final float albedo;
    private final float rotationSpeed;
    public final boolean isPlanet;
    private final int decoration;
    private final int[] mainColor;
    private final int[] secondaryColor;
    public final OrbitingBodyType type;
    private float angle;
    private int currentAlpha;
    private Vector3f axis1;
    private Vector3f axis2;
    private Vector3f quad1vertex1;
    private Vector3f quad1vertex2;
    private Vector3f quad1vertex3;
    private Vector3f quad1vertex4;
    private Vector3f quad2vertex1;
    private Vector3f quad2vertex2;
    private Vector3f quad2vertex3;
    private Vector3f quad2vertex4;
    private Vector3f position;
    public String name;
    public static OrbitingBody selected;
    private boolean isSelected;

    public OrbitingBody(Orbit orbit, float size, float albedo, float rotationSpeed, boolean isPlanet, int decoration, int[] mainColor, int[] secondaryColor, OrbitingBodyType type) {
        this.orbit = orbit;
        this.size = size;
        this.albedo = albedo;
        this.rotationSpeed = rotationSpeed * 0.1f;
        this.isPlanet = isPlanet;
        this.decoration = decoration;
        this.mainColor = mainColor;
        this.secondaryColor = secondaryColor;
        this.type = type;
    }

    public void addMoon(OrbitingBody moon) {
        this.moons.add(moon);
    }

    public void update(int ticks, Vector3f referencePosition, Vector3f normalisedReferencePosition, Long day, float dayFraction) {
        this.angle = (this.angle + this.rotationSpeed) % 360.0f;
        this.position = this.orbit.getRotatedPositionAtGlobalTime(day, dayFraction, true);
        Vector3f similarityVector = new Vector3f((Vector3fc)this.position);
        similarityVector.normalize();
        float similarity = similarityVector.dot((Vector3fc)normalisedReferencePosition);
        this.position.sub((Vector3fc)referencePosition);
        float sqrDistance = SpyglassAstronomyClient.getSquaredDistance(this.position.x, this.position.y, this.position.z);
        float inverseSqrt = class_3532.method_22858((float)sqrDistance);
        this.position.mul(inverseSqrt);
        float distance = 1.0f / inverseSqrt / SpyglassAstronomyClient.earthOrbit.semiMajorAxis;
        float visibilityScale = Math.min(class_3532.method_15355((float)distance), 8.0f);
        this.axis1 = this.orbit.getRotatedPositionAtGlobalTime(day, dayFraction - this.orbit.period / 32.0f, false);
        this.axis1.sub((Vector3fc)referencePosition);
        this.axis1.normalize();
        this.axis1.sub((Vector3fc)this.position);
        this.axis1.normalize();
        this.axis2 = new Vector3f((Vector3fc)this.axis1);
        this.axis2.rotate((Quaternionfc)class_7833.method_46356((Vector3f)this.position).rotationDegrees(90.0f));
        float sizeScale = class_3532.method_15363((float)(this.size / visibilityScale * 3.0f), (float)0.25f, (float)1.5f);
        this.axis1.mul(sizeScale);
        this.axis2.mul(sizeScale);
        float heightScale = SpaceRenderingManager.getHeightScale();
        float heightFactor = 1.0f;
        float alphaRaw = Math.max((Math.min(this.albedo * 10.0f * heightScale - visibilityScale + heightFactor, 1.0f) + heightScale) / 2.0f, 0.0f);
        if ((double)similarity < -0.5) {
            float offsetSimilarity = 2.0f * (similarity + 0.5f);
            alphaRaw *= 1.0f - offsetSimilarity * offsetSimilarity;
        }
        this.currentAlpha = (int)(alphaRaw * 255.0f);
        Quaternionf rotation = class_7833.method_46356((Vector3f)this.position).rotationDegrees(this.angle);
        Vector3f rotatedAxis1 = new Vector3f((Vector3fc)this.axis1);
        Vector3f rotatedAxis2 = new Vector3f((Vector3fc)this.axis2);
        rotatedAxis1.rotate((Quaternionfc)rotation);
        rotatedAxis2.rotate((Quaternionfc)rotation);
        float x = this.position.x * 100.0f;
        float y = this.position.y * 100.0f;
        float z = this.position.z * 100.0f;
        this.quad1vertex1 = new Vector3f(x, y, z);
        this.quad1vertex2 = new Vector3f(x, y, z);
        this.quad1vertex3 = new Vector3f(x, y, z);
        this.quad1vertex4 = new Vector3f(x, y, z);
        this.quad1vertex1.sub((Vector3fc)rotatedAxis2);
        this.quad1vertex2.sub((Vector3fc)rotatedAxis1);
        this.quad1vertex3.add((Vector3fc)rotatedAxis2);
        this.quad1vertex4.add((Vector3fc)rotatedAxis1);
        if (this.isPlanet) {
            switch (this.decoration) {
                case 0: {
                    this.quad2vertex1 = new Vector3f(x, y, z);
                    this.quad2vertex2 = new Vector3f((Vector3fc)this.quad1vertex2);
                    this.quad2vertex3 = new Vector3f((Vector3fc)this.quad1vertex3);
                    this.quad2vertex4 = new Vector3f((Vector3fc)this.quad1vertex4);
                    break;
                }
                case 1: {
                    float ringOut = 1.3f;
                    float ringIn = 0.9f;
                    Quaternionf slowOppositeRotation = class_7833.method_46356((Vector3f)this.position).rotationDegrees(-this.angle / 2.0f);
                    Vector3f in1 = new Vector3f((Vector3fc)this.axis1);
                    in1.rotate((Quaternionfc)slowOppositeRotation);
                    Vector3f out1 = new Vector3f((Vector3fc)in1);
                    Vector3f in2 = new Vector3f((Vector3fc)this.axis2);
                    in2.rotate((Quaternionfc)slowOppositeRotation);
                    Vector3f out2 = new Vector3f((Vector3fc)in2);
                    in1.mul(ringIn);
                    out1.mul(ringOut);
                    in2.mul(ringIn);
                    out2.mul(ringOut);
                    this.quad2vertex1 = new Vector3f(x, y, z);
                    this.quad2vertex2 = new Vector3f(x, y, z);
                    this.quad2vertex3 = new Vector3f(x, y, z);
                    this.quad2vertex4 = new Vector3f(x, y, z);
                    this.quad2vertex1.sub((Vector3fc)out2);
                    this.quad2vertex1.sub((Vector3fc)in1);
                    this.quad2vertex2.sub((Vector3fc)out1);
                    this.quad2vertex2.sub((Vector3fc)in2);
                    this.quad2vertex3.add((Vector3fc)out2);
                    this.quad2vertex3.add((Vector3fc)in1);
                    this.quad2vertex4.add((Vector3fc)out1);
                    this.quad2vertex4.add((Vector3fc)in2);
                    break;
                }
                case 2: 
                case 3: {
                    this.quad2vertex1 = this.decoration == 2 ? new Vector3f(x, y, z) : new Vector3f((Vector3fc)this.quad1vertex1);
                    this.quad2vertex2 = new Vector3f(x, y, z);
                    this.quad2vertex3 = new Vector3f((Vector3fc)this.quad1vertex3);
                    this.quad2vertex4 = new Vector3f(x, y, z);
                    Vector3f offset1 = new Vector3f((Vector3fc)rotatedAxis2);
                    Vector3f offset2 = new Vector3f((Vector3fc)rotatedAxis2);
                    offset1.add((Vector3fc)rotatedAxis1);
                    offset2.sub((Vector3fc)rotatedAxis1);
                    offset1.mul(0.5f);
                    offset2.mul(0.5f);
                    this.quad2vertex2.add((Vector3fc)offset2);
                    this.quad2vertex4.add((Vector3fc)offset1);
                }
            }
        } else {
            this.quad2vertex1 = new Vector3f(x, y, z);
            this.quad2vertex2 = new Vector3f(x, y, z);
            this.quad2vertex3 = new Vector3f(x, y, z);
            this.quad2vertex4 = new Vector3f(x, y, z);
            Vector3f trailEnd = new Vector3f((Vector3fc)this.axis1);
            trailEnd.mul(6.0f);
            this.quad2vertex1.add((Vector3fc)trailEnd);
            this.quad2vertex2.add((Vector3fc)trailEnd);
            this.quad2vertex3.add((Vector3fc)this.axis1);
            this.quad2vertex4.add((Vector3fc)this.axis1);
            Vector3f trailWidth = new Vector3f((Vector3fc)this.axis2);
            trailWidth.mul(0.75f);
            if (this.decoration != 0) {
                this.quad2vertex1.add((Vector3fc)trailWidth);
                this.quad2vertex2.sub((Vector3fc)trailWidth);
            }
            if (this.decoration != 2) {
                this.quad2vertex3.sub((Vector3fc)trailWidth);
                this.quad2vertex4.add((Vector3fc)trailWidth);
            }
        }
    }

    public void setVertices(class_287 bufferBuilder) {
        int colorMult = this.isSelected ? 1 : 0;
        int r1 = this.mainColor[0] >> colorMult;
        int g1 = this.mainColor[1];
        int b1 = this.mainColor[2] >> colorMult;
        int r2 = this.secondaryColor[0] >> colorMult;
        int g2 = this.secondaryColor[1];
        int b2 = this.secondaryColor[2] >> colorMult;
        int decorationAlpha = this.currentAlpha / 3;
        bufferBuilder.method_22912((double)this.quad1vertex1.x, (double)this.quad1vertex1.y, (double)this.quad1vertex1.z).method_1336(r1, g1, b1, this.currentAlpha).method_1344();
        bufferBuilder.method_22912((double)this.quad1vertex2.x, (double)this.quad1vertex2.y, (double)this.quad1vertex2.z).method_1336(r1, g1, b1, this.currentAlpha).method_1344();
        bufferBuilder.method_22912((double)this.quad1vertex3.x, (double)this.quad1vertex3.y, (double)this.quad1vertex3.z).method_1336(r1, g1, b1, this.currentAlpha).method_1344();
        bufferBuilder.method_22912((double)this.quad1vertex4.x, (double)this.quad1vertex4.y, (double)this.quad1vertex4.z).method_1336(r1, g1, b1, this.currentAlpha).method_1344();
        bufferBuilder.method_22912((double)this.quad2vertex1.x, (double)this.quad2vertex1.y, (double)this.quad2vertex1.z).method_1336(r2, g2, b2, this.isPlanet ? decorationAlpha : 0).method_1344();
        bufferBuilder.method_22912((double)this.quad2vertex2.x, (double)this.quad2vertex2.y, (double)this.quad2vertex2.z).method_1336(r2, g2, b2, this.isPlanet ? decorationAlpha : 0).method_1344();
        bufferBuilder.method_22912((double)this.quad2vertex3.x, (double)this.quad2vertex3.y, (double)this.quad2vertex3.z).method_1336(r2, g2, b2, decorationAlpha).method_1344();
        bufferBuilder.method_22912((double)this.quad2vertex4.x, (double)this.quad2vertex4.y, (double)this.quad2vertex4.z).method_1336(r2, g2, b2, decorationAlpha).method_1344();
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getCurrentNonTwinkledAlpha() {
        return (float)this.currentAlpha / 255.0f;
    }

    public void select() {
        Constellation.deselect();
        Star.deselect();
        if (selected != null) {
            OrbitingBody.selected.isSelected = false;
        }
        this.isSelected = true;
        selected = this;
    }

    public static void deselect() {
        if (selected != null) {
            OrbitingBody.selected.isSelected = false;
        }
        selected = null;
    }

    public static enum OrbitingBodyType {
        TERRESTIAL,
        HABITABLE,
        OCEANPLANET,
        ICEPLANET,
        GASGIANT,
        ICEGIANT,
        COMET;

    }
}

