/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.KeplerLookup;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Orbit {
    public final float period;
    public final float eccentricity;
    public final float semiMajorAxis;
    public final float distance;
    public final float rotation;
    public final float inclination;
    public final float timeOffset;
    public float lastLocalTime;
    private static final double k = 1.0;

    public Orbit(double period, double eccentricity, float rotation, float inclination, float timeOffset) {
        double semiMajorAxis = Math.cbrt(period * period / 1.0);
        double distance = semiMajorAxis * (1.0 - eccentricity * eccentricity);
        this.period = (float)period;
        this.eccentricity = (float)eccentricity;
        this.semiMajorAxis = (float)semiMajorAxis;
        this.distance = (float)distance;
        this.rotation = rotation;
        this.inclination = inclination;
        this.timeOffset = timeOffset;
    }

    public float getLocalAngleAtLocalTime(float t) {
        return KeplerLookup.getAt(this.eccentricity, t % 1.0f * 2.0f);
    }

    public Vector3f getLocalPositionAtLocalTime(float t, boolean updateLastPos) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (updateLastPos) {
            this.lastLocalTime = t;
        }
        float f = this.getLocalAngleAtLocalTime(t);
        float cosAngle = class_3532.method_15362((float)f);
        float scale = this.distance / (1.0f + this.eccentricity * cosAngle);
        return new Vector3f(cosAngle * scale, class_3532.method_15374((float)f) * scale, 0.0f);
    }

    public Vector3f getRotatedPositionAtGlobalTime(Long day, float dayFraction, boolean updateLastPos) {
        Vector3f pos = this.getLocalPositionAtLocalTime(((float)day.longValue() % this.period / this.period + dayFraction / this.period + this.timeOffset) % 1.0f, updateLastPos);
        this.rotateLocalPosition(pos);
        return pos;
    }

    public void rotateLocalPosition(Vector3f vector) {
        vector.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.inclination));
        vector.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.rotation));
    }

    public Vector3f getLastRotatedPosition() {
        Vector3f pos = this.getLocalPositionAtLocalTime(this.lastLocalTime, false);
        this.rotateLocalPosition(pos);
        return pos;
    }
}

