/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.StarLine;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Constellation {
    private ArrayList<StarLine> lines = new ArrayList();
    public String name = "Unnamed";
    private Vector3f averagePositionBuffer;
    private boolean averagePositionValid;
    public static Constellation selected;
    private boolean isSelected;

    public Constellation() {
    }

    public Constellation(StarLine starLine) {
        this.lines.add(starLine);
    }

    public void setVertices(class_287 bufferBuilder, boolean forceSelected) {
        for (StarLine line : this.lines) {
            line.setVertices(bufferBuilder, this.isSelected || forceSelected);
        }
    }

    public Constellation addLineCanRemove(StarLine starLine) {
        this.averagePositionValid = false;
        int end = this.lines.size();
        for (int i = 0; i < end; ++i) {
            StarLine line = this.lines.get(i);
            if (!line.isSame(starLine)) continue;
            line.clear();
            this.lines.remove(i);
            return this.trySplit(starLine);
        }
        this.lines.add(starLine);
        return null;
    }

    public Constellation addLine(StarLine starLine) {
        for (StarLine line : this.lines) {
            if (!line.isSame(starLine)) continue;
            return null;
        }
        this.lines.add(starLine);
        this.averagePositionValid = false;
        return null;
    }

    public Constellation trySplit(StarLine reference) {
        Star[] refStars = reference.getStars();
        int start = refStars[0].index;
        int end = refStars[1].index;
        ArrayList<Integer> found = new ArrayList<Integer>();
        boolean continueSearch = true;
        found.add(start);
        while (continueSearch) {
            continueSearch = false;
            for (StarLine starLine : this.lines) {
                for (int index = 0; index < found.size(); ++index) {
                    int star = (Integer)found.get(index);
                    if (!starLine.hasStar(star)) continue;
                    if (starLine.hasStar(end)) {
                        return null;
                    }
                    int other = starLine.getOtherStar(star);
                    if (found.contains(other)) continue;
                    found.add(other);
                    continueSearch = true;
                }
            }
        }
        ArrayList<Integer> all = new ArrayList<Integer>();
        for (StarLine line : this.lines) {
            Star[] stars = line.getStars();
            int a = stars[0].index;
            int b = stars[1].index;
            if (!all.contains(a)) {
                all.add(a);
            }
            if (all.contains(b)) continue;
            all.add(b);
        }
        if (found.size() != all.size()) {
            Constellation constellation = new Constellation();
            for (StarLine line : this.lines) {
                boolean isFound = false;
                Iterator iterator = found.iterator();
                while (iterator.hasNext()) {
                    int star = (Integer)iterator.next();
                    if (!line.hasStar(star)) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                constellation.addLine(line);
            }
            if (constellation.lines.size() == this.lines.size()) {
                return null;
            }
            for (StarLine newLine : constellation.lines) {
                int index = 0;
                while (index < this.lines.size()) {
                    if (this.lines.get(index).isSame(newLine)) {
                        this.lines.remove(index);
                        continue;
                    }
                    ++index;
                }
            }
            constellation.name = this.name;
            return constellation;
        }
        return null;
    }

    public boolean lineIntersects(StarLine starLine) {
        for (StarLine line : this.lines) {
            if (!line.intersects(starLine)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStar(Star star) {
        int index = star.index;
        for (StarLine line : this.lines) {
            if (!line.hasStar(index)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<StarLine> getLines() {
        return this.lines;
    }

    public void initaliseStarLines() {
        for (StarLine line : this.lines) {
            line.initialise();
        }
    }

    public Vector3f getAveragePosition() {
        if (this.averagePositionValid) {
            return this.averagePositionBuffer;
        }
        this.averagePositionBuffer = new Vector3f();
        ArrayList<Star> stars = new ArrayList<Star>();
        for (StarLine line : this.lines) {
            Star[] lineStars = line.getStars();
            if (!stars.contains(lineStars[0])) {
                stars.add(lineStars[0]);
            }
            if (stars.contains(lineStars[1])) continue;
            stars.add(lineStars[1]);
        }
        for (Star star : stars) {
            this.averagePositionBuffer.add((Vector3fc)star.getPositionAsVector3f());
        }
        float x = this.averagePositionBuffer.x;
        float y = this.averagePositionBuffer.y;
        float z = this.averagePositionBuffer.z;
        float isqrt = class_3532.method_22858((float)(x * x + y * y + z * z));
        this.averagePositionBuffer.mul(isqrt);
        this.averagePositionValid = true;
        return new Vector3f((Vector3fc)this.averagePositionBuffer);
    }

    public void select() {
        Star.deselect();
        OrbitingBody.deselect();
        if (selected != null) {
            Constellation.selected.isSelected = false;
        }
        this.isSelected = true;
        selected = this;
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
    }

    public static void deselect() {
        if (selected != null) {
            Constellation.selected.isSelected = false;
        }
        selected = null;
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
    }
}

