/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.util.ClassFinder;
import me.lucko.spark.fabric.smap.MixinUtils;
import me.lucko.spark.fabric.smap.SourceMap;
import me.lucko.spark.fabric.smap.SourceMapProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public class FabricClassSourceLookup
extends ClassSourceLookup.ByCodeSource {
    private final ClassFinder classFinder = new ClassFinder();
    private final SourceMapProvider smapProvider = new SourceMapProvider();
    private final Path modsDirectory;
    private final Map<String, String> pathToModMap;

    public FabricClassSourceLookup() {
        FabricLoader loader = FabricLoader.getInstance();
        this.modsDirectory = loader.getGameDir().resolve("mods").toAbsolutePath().normalize();
        this.pathToModMap = FabricClassSourceLookup.constructPathToModIdMap(loader.getAllMods());
    }

    @Override
    public String identifyFile(Path path) {
        String id = this.pathToModMap.get(path.toAbsolutePath().normalize().toString());
        if (id != null) {
            return id;
        }
        if (!path.startsWith(this.modsDirectory)) {
            return null;
        }
        return super.identifyFileName(this.modsDirectory.relativize(path).toString());
    }

    @Override
    public String identify(ClassSourceLookup.MethodCall methodCall) throws Exception {
        String className = methodCall.getClassName();
        String methodName = methodCall.getMethodName();
        String methodDesc = methodCall.getMethodDescriptor();
        if (className.equals("native") || methodName.equals("<init>") || methodName.equals("<clinit>")) {
            return null;
        }
        Class<?> clazz = this.classFinder.findClass(className);
        if (clazz == null) {
            return null;
        }
        Class<?>[] params = this.getParameterTypesForMethodDesc(methodDesc);
        Method reflectMethod = clazz.getDeclaredMethod(methodName, params);
        MixinMerged mixinMarker = reflectMethod.getDeclaredAnnotation(MixinMerged.class);
        if (mixinMarker == null) {
            return null;
        }
        return FabricClassSourceLookup.modIdFromMixinClass(mixinMarker.mixin());
    }

    @Override
    public String identify(ClassSourceLookup.MethodCallByLine methodCall) throws Exception {
        String className = methodCall.getClassName();
        String methodName = methodCall.getMethodName();
        int lineNumber = methodCall.getLineNumber();
        if (className.equals("native") || methodName.equals("<init>") || methodName.equals("<clinit>")) {
            return null;
        }
        SourceMap smap = this.smapProvider.getSourceMap(className);
        if (smap == null) {
            return null;
        }
        int[] inputLineInfo = smap.getReverseLineMapping().get(lineNumber);
        if (inputLineInfo == null || inputLineInfo.length == 0) {
            return null;
        }
        for (int fileInfoIds : inputLineInfo) {
            String possibleMixinClassName;
            SourceMap.FileInfo inputFileInfo = smap.getFileInfo().get(fileInfoIds);
            if (inputFileInfo == null) continue;
            String path = inputFileInfo.path();
            if (path.endsWith(".java")) {
                path = path.substring(0, path.length() - 5);
            }
            if ((possibleMixinClassName = path.replace('/', '.')).equals(className)) continue;
            return FabricClassSourceLookup.modIdFromMixinClass(possibleMixinClassName);
        }
        return null;
    }

    private static String modIdFromMixinClass(String mixinClassName) {
        for (Config config : MixinUtils.getMixinConfigs().values()) {
            IMixinConfig mixinConfig = config.getConfig();
            if (!mixinClassName.startsWith(mixinConfig.getMixinPackage())) continue;
            return (String)mixinConfig.getDecoration("fabric-modId");
        }
        return null;
    }

    private Class<?>[] getParameterTypesForMethodDesc(String methodDesc) {
        Type methodType = Type.getMethodType((String)methodDesc);
        Class[] params = new Class[methodType.getArgumentTypes().length];
        for (Type argumentType : methodType.getArgumentTypes()) {
            params[i] = this.getClassFromType(argumentType);
        }
        return params;
    }

    private Class<?> getClassFromType(Type type) {
        return switch (type.getSort()) {
            case 0 -> Void.TYPE;
            case 1 -> Boolean.TYPE;
            case 2 -> Character.TYPE;
            case 3 -> Byte.TYPE;
            case 4 -> Short.TYPE;
            case 5 -> Integer.TYPE;
            case 6 -> Float.TYPE;
            case 7 -> Long.TYPE;
            case 8 -> Double.TYPE;
            case 9 -> {
                Class<?> classFromType;
                TypeDescriptor.OfField<Class<?>> result = classFromType = this.getClassFromType(type.getElementType());
                if (classFromType != null) {
                    for (int i = 0; i < type.getDimensions(); ++i) {
                        result = result.arrayType();
                    }
                }
                yield result;
            }
            case 10 -> this.classFinder.findClass(type.getClassName());
            default -> null;
        };
    }

    private static Map<String, String> constructPathToModIdMap(Collection<ModContainer> mods) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModContainer mod : mods) {
            String modId = mod.getMetadata().getId();
            if (modId.equals("java")) continue;
            for (Path path : mod.getRootPaths()) {
                URI uri = path.toUri();
                if (uri.getScheme().equals("jar") && path.toString().equals("/")) {
                    String zipFilePath = path.getFileSystem().toString();
                    builder.put((Object)zipFilePath, (Object)modId);
                    continue;
                }
                builder.put((Object)path.toAbsolutePath().normalize().toString(), (Object)modId);
            }
        }
        return builder.build();
    }
}

