/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util.ws;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import me.lucko.spark.common.util.ws.BytesocksClient;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BytesocksClientImpl
implements BytesocksClient {
    private final HttpClient client = HttpClient.newHttpClient();
    private final String httpUrl;
    private final String wsUrl;
    private final String userAgent;

    BytesocksClientImpl(String host, String userAgent) {
        this.httpUrl = "https://" + host + "/";
        this.wsUrl = "wss://" + host + "/";
        this.userAgent = userAgent;
    }

    @Override
    public BytesocksClient.Socket createAndConnect(BytesocksClient.Listener listener) throws Exception {
        HttpRequest createRequest = HttpRequest.newBuilder().uri(URI.create(this.httpUrl + "create")).header("User-Agent", this.userAgent).build();
        HttpResponse<Void> resp = this.client.send(createRequest, HttpResponse.BodyHandlers.discarding());
        if (resp.statusCode() != 201) {
            throw new RuntimeException("Request failed: " + resp);
        }
        String channelId = resp.headers().firstValue("Location").orElse(null);
        if (channelId == null) {
            throw new RuntimeException("Location header not returned: " + resp);
        }
        return this.connect(channelId, listener);
    }

    @Override
    public BytesocksClient.Socket connect(String channelId, BytesocksClient.Listener listener) throws Exception {
        WebSocket socket = this.client.newWebSocketBuilder().header("User-Agent", this.userAgent).connectTimeout(Duration.ofSeconds(5L)).buildAsync(URI.create(this.wsUrl + channelId), new ListenerImpl(listener)).join();
        return new SocketImpl(channelId, socket);
    }

    private static final class ListenerImpl
    implements WebSocket.Listener {
        private final BytesocksClient.Listener listener;

        private ListenerImpl(BytesocksClient.Listener listener) {
            this.listener = listener;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            this.listener.onOpen();
            webSocket.request(1L);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            return CompletableFuture.runAsync(() -> this.listener.onClose(statusCode, reason));
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError(error);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            webSocket.request(1L);
            return CompletableFuture.runAsync(() -> this.listener.onText(data));
        }
    }

    private static final class SocketImpl
    implements BytesocksClient.Socket {
        private final String id;
        private final WebSocket ws;

        private SocketImpl(String id, WebSocket ws) {
            this.id = id;
            this.ws = ws;
        }

        @Override
        public String getChannelId() {
            return this.id;
        }

        @Override
        public boolean isOpen() {
            return !this.ws.isOutputClosed() && !this.ws.isInputClosed();
        }

        @Override
        public CompletableFuture<?> send(CharSequence msg) {
            return this.ws.sendText(msg, true);
        }

        @Override
        public void close(int statusCode, String reason) {
            this.ws.sendClose(statusCode, reason);
        }
    }
}

