/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.integration.voicechat;

import com.sonicether.soundphysics.SoundPhysics;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_243;
import net.minecraft.class_3419;

public class AudioChannel {
    private final UUID channelId;
    private long lastUpdate;
    private class_243 lastPos;

    public AudioChannel(UUID channelId) {
        this.channelId = channelId;
    }

    public void onSound(int source, @Nullable class_243 soundPos, boolean auxOnly) {
        if (soundPos == null) {
            SoundPhysics.setDefaultEnvironment(source, auxOnly);
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 500L && this.lastPos != null && this.lastPos.method_1022(soundPos) < 1.0) {
            return;
        }
        SoundPhysics.setLastSoundCategoryAndName(class_3419.field_15250, "voicechat");
        if (auxOnly) {
            SoundPhysics.onPlayReverb(soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), source);
        } else {
            SoundPhysics.onPlaySound(soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), source);
        }
        this.lastUpdate = time;
        this.lastPos = soundPos;
    }

    public UUID getChannelId() {
        return this.channelId;
    }

    public boolean canBeRemoved() {
        return System.currentTimeMillis() - this.lastUpdate > 5000L;
    }
}

