/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.SoundTypes;
import com.sonicether.soundphysics.configbuilder.PropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2498;

public class ReflectivityConfig
extends PropertyConfig {
    private Map<class_2498, Double> reflectivity;

    public ReflectivityConfig(Path path) {
        super(path);
        this.save();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.reflectivity = this.createDefaultMap();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            double value;
            String key = (String)entry.getKey();
            try {
                value = Double.parseDouble((String)entry.getValue());
            }
            catch (NumberFormatException e) {
                SoundPhysics.LOGGER.warn("Failed to parse reflectivity of {}", (Object)key);
                continue;
            }
            class_2498 soundType = SoundTypes.getSoundType(key);
            if (soundType == null) {
                SoundPhysics.LOGGER.warn("Sound type {} not found", (Object)key);
                continue;
            }
            this.reflectivity.put(soundType, value);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        for (Map.Entry<class_2498, Double> entry : this.reflectivity.entrySet()) {
            this.properties.put(SoundTypes.getName(entry.getKey()), String.valueOf(entry.getValue()));
        }
        super.saveSync();
    }

    public Map<class_2498, Double> getReflectivities() {
        return this.reflectivity;
    }

    public double getReflectivity(class_2498 soundType) {
        return this.reflectivity.getOrDefault(soundType, SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get());
    }

    public ReflectivityConfig setReflectivity(class_2498 soundType, double value) {
        this.reflectivity.put(soundType, value);
        return this;
    }

    public Map<class_2498, Double> createDefaultMap() {
        HashMap<class_2498, Double> map = new HashMap<class_2498, Double>();
        for (class_2498 type : SoundTypes.getTranslationMap().keySet()) {
            map.put(type, SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get());
        }
        map.put(class_2498.field_11544, 1.5);
        map.put(class_2498.field_22150, 1.5);
        map.put(class_2498.field_27202, 1.5);
        map.put(class_2498.field_27197, 1.5);
        map.put(class_2498.field_22143, 1.5);
        map.put(class_2498.field_27203, 1.5);
        map.put(class_2498.field_22149, 1.5);
        map.put(class_2498.field_27204, 1.25);
        map.put(class_2498.field_29033, 1.5);
        map.put(class_2498.field_29034, 1.5);
        map.put(class_2498.field_29035, 1.5);
        map.put(class_2498.field_29036, 1.5);
        map.put(class_2498.field_22146, 1.5);
        map.put(class_2498.field_22145, 1.1);
        map.put(class_2498.field_24120, 1.1);
        map.put(class_2498.field_22148, 1.1);
        map.put(class_2498.field_22152, 0.4);
        map.put(class_2498.field_11543, 0.1);
        map.put(class_2498.field_21214, 0.1);
        map.put(class_2498.field_28697, 0.1);
        map.put(class_2498.field_22141, 0.2);
        map.put(class_2498.field_22142, 0.2);
        map.put(class_2498.field_11528, 0.2);
        map.put(class_2498.field_11533, 1.25);
        map.put(class_2498.field_11547, 0.4);
        map.put(class_2498.field_11529, 0.3);
        map.put(class_2498.field_11535, 0.3);
        map.put(class_2498.field_11537, 0.75);
        map.put(class_2498.field_11526, 0.2);
        map.put(class_2498.field_11548, 0.15);
        return map;
    }
}

