/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.particle.fast_render;

import me.jellysquid.mods.sodium.client.render.RenderGlobal;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ParticleVertex;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_3940.class})
public abstract class MixinBillboardParticle
extends class_703 {
    @Shadow
    public abstract float method_18132(float var1);

    @Shadow
    protected abstract float method_18133();

    @Shadow
    protected abstract float method_18134();

    @Shadow
    protected abstract float method_18135();

    @Shadow
    protected abstract float method_18136();

    protected MixinBillboardParticle(class_638 world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Overwrite
    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        Quaternionf quaternion;
        class_243 vec3d = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        if (this.field_3839 == 0.0f) {
            quaternion = camera.method_23767();
        } else {
            float angle = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion = new Quaternionf((Quaternionfc)camera.method_23767());
            quaternion.rotateZ(angle);
        }
        float size = this.method_18132(tickDelta);
        int light = this.method_3068(tickDelta);
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int color = ColorABGR.pack(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        VertexBufferWriter writer = VertexBufferWriter.of(vertexConsumer);
        try (MemoryStack stack = RenderGlobal.VERTEX_DATA.push();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            MixinBillboardParticle.writeVertex(ptr, quaternion, -1.0f, -1.0f, x, y, z, maxU, maxV, color, light, size);
            MixinBillboardParticle.writeVertex(ptr += 28L, quaternion, -1.0f, 1.0f, x, y, z, maxU, minV, color, light, size);
            MixinBillboardParticle.writeVertex(ptr += 28L, quaternion, 1.0f, 1.0f, x, y, z, minU, minV, color, light, size);
            MixinBillboardParticle.writeVertex(ptr += 28L, quaternion, 1.0f, -1.0f, x, y, z, minU, maxV, color, light, size);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }

    private static void writeVertex(long buffer, Quaternionf rotation, float posX, float posY, float originX, float originY, float originZ, float u, float v, int color, int light, float size) {
        float q0x = rotation.x();
        float q0y = rotation.y();
        float q0z = rotation.z();
        float q0w = rotation.w();
        float q1x = q0w * posX - q0z * posY;
        float q1y = q0w * posY + q0z * posX;
        float q1w = q0x * posY - q0y * posX;
        float q1z = -(q0x * posX) - q0y * posY;
        float q2x = -q0x;
        float q2y = -q0y;
        float q2z = -q0z;
        float q2w = q0w;
        float q3x = q1z * q2x + q1x * q2w + q1y * q2z - q1w * q2y;
        float q3y = q1z * q2y - q1x * q2z + q1y * q2w + q1w * q2x;
        float q3z = q1z * q2z + q1x * q2y - q1y * q2x + q1w * q2w;
        float fx = q3x * size + originX;
        float fy = q3y * size + originY;
        float fz = q3z * size + originZ;
        ParticleVertex.write(buffer, fx, fy, fz, u, v, color, light);
    }
}

