/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_827;
import net.minecraft.class_852;

public class ChunkRenderRebuildTask
extends ChunkRenderBuildTask {
    private final RenderSection render;
    private final ChunkRenderContext renderContext;
    private final int frame;

    public ChunkRenderRebuildTask(RenderSection render, ChunkRenderContext renderContext, int frame) {
        this.render = render;
        this.renderContext = renderContext;
        this.frame = frame;
    }

    @Override
    public ChunkBuildResult performBuild(ChunkBuildContext buildContext, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        class_852 occluder = new class_852();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getChunkId());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        WorldSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2338.class_2339 modelOffset = new class_2338.class_2339();
        BlockRenderContext context = new BlockRenderContext(slice);
        for (int y = minY; y < maxY; ++y) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    class_827 renderer;
                    class_2586 entity;
                    class_3610 fluidState;
                    class_2680 blockState = slice.getBlockState(x, y, z);
                    if (blockState.method_26215()) continue;
                    blockPos.method_10103(x, y, z);
                    modelOffset.method_10103(x & 0xF, y & 0xF, z & 0xF);
                    boolean rendered = false;
                    if (blockState.method_26217() == class_2464.field_11458) {
                        class_1921 layer = class_4696.method_23679((class_2680)blockState);
                        class_1087 model = cache.getBlockModels().method_3335(blockState);
                        long seed = blockState.method_26190((class_2338)blockPos);
                        context.update((class_2338)blockPos, (class_2338)modelOffset, blockState, model, seed);
                        if (cache.getBlockRenderer().renderModel(context, buffers.get(layer))) {
                            rendered = true;
                        }
                    }
                    if (!(fluidState = blockState.method_26227()).method_15769()) {
                        class_1921 layer = class_4696.method_23680((class_3610)fluidState);
                        if (cache.getFluidRenderer().render(slice, fluidState, (class_2338)blockPos, (class_2338)modelOffset, buffers.get(layer))) {
                            rendered = true;
                        }
                    }
                    if (blockState.method_31709() && (entity = slice.method_8321((class_2338)blockPos)) != null && (renderer = class_310.method_1551().method_31975().method_3550(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.method_3563(entity));
                    }
                    if (blockState.method_26216((class_1922)slice, (class_2338)blockPos)) {
                        occluder.method_3682((class_2338)blockPos);
                    }
                    if (!rendered) continue;
                    bounds.addBlock(x & 0xF, y & 0xF, z & 0xF);
                }
            }
        }
        EnumMap<BlockRenderPass, ChunkMeshData> meshes = new EnumMap<BlockRenderPass, ChunkMeshData>(BlockRenderPass.class);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            meshes.put(pass, mesh);
        }
        renderData.setOcclusionData(occluder.method_3679());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult(this.render, renderData.build(), meshes, this.frame);
    }

    @Override
    public void releaseResources() {
        this.renderContext.releaseResources();
    }
}

