/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.server.SkinProviderController;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SkinsCommand {
    static final class_2561 ISSUER = class_2561.method_43470((String)"SkinChanger");

    public static ArgumentBuilder<class_2168, ?> setCommand(Function3<class_2168, class_1657, String, Integer> setFunction, Function<CommandContext<class_2168>, class_1657> getTarget) {
        return class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"arg", (ArgumentType)class_2196.method_9340()).executes(context -> (Integer)setFunction.apply((class_2168)context.getSource(), (class_1657)getTarget.apply(context), class_2196.method_9339((CommandContext)context, (String)"arg").getString())));
    }

    public static ArgumentBuilder<class_2168, ?> clearCommand(Function2<class_2168, class_1657, Integer> clearFunction, Function<CommandContext<class_2168>, class_1657> getTarget) {
        return class_2170.method_9247((String)"clear").executes(context -> (Integer)clearFunction.apply((class_2168)context.getSource(), (class_1657)getTarget.apply(context)));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").then(SkinsCommand.setCommand(SkinsCommand::setPlayerSkin, context -> ((class_2168)context.getSource()).method_9207()))).then(SkinsCommand.clearCommand(SkinsCommand::clearPlayerSkin, context -> ((class_2168)context.getSource()).method_9207()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(player -> player.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(SkinsCommand.setCommand(SkinsCommand::setPlayerSkin, context -> class_2186.method_9315((CommandContext)context, (String)"target")))).then(SkinsCommand.clearCommand(SkinsCommand::clearPlayerSkin, context -> class_2186.method_9315((CommandContext)context, (String)"target"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cape").then(SkinsCommand.setCommand(SkinsCommand::setPlayerCape, context -> ((class_2168)context.getSource()).method_9207()))).then(SkinsCommand.clearCommand(SkinsCommand::clearPlayerCape, context -> ((class_2168)context.getSource()).method_9207()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(player -> player.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(SkinsCommand.setCommand(SkinsCommand::setPlayerCape, context -> class_2186.method_9315((CommandContext)context, (String)"target")))).then(SkinsCommand.clearCommand(SkinsCommand::clearPlayerCape, context -> class_2186.method_9315((CommandContext)context, (String)"target"))))));
    }

    private static Integer setPlayerSkin(class_2168 source, class_1297 targetEntity, String arg) {
        MinecraftServer sourcePlayer = source.method_9211();
        if (source.method_9228() != null) {
            sourcePlayer = source.method_9228();
        }
        class_1657 targetPlayer = (class_1657)targetEntity;
        try {
            URL url = new URL(arg);
            return SkinsCommand.setPlayerSkinByURL((class_2165)sourcePlayer, targetPlayer, url);
        }
        catch (MalformedURLException e) {
            return SkinsCommand.setPlayerSkinByName((class_2165)sourcePlayer, targetPlayer, arg);
        }
    }

    private static Integer setPlayerSkinByName(class_2165 sourcePlayer, class_1657 targetPlayer, String playerName) {
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.loading")}));
        if (playerName.equalsIgnoreCase("original")) {
            boolean sentWithAnimation = SkinsCommand.sendSkinPacketWithAnimation(targetPlayer, "original", "RADIAL", 20);
            if (sentWithAnimation) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43470((String)"\u00a7aLoading original skin with animation...")}));
                return 1;
            }
            playerName = targetPlayer.method_7334().getName();
        }
        String finalTargetName = playerName;
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerSkinByName(targetPlayer.method_7334(), finalTargetName, true)) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.load_failed")}));
            } else {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.load_succeeded")}));
            }
        });
        return 1;
    }

    private static boolean sendSkinPacketWithAnimation(class_1657 targetPlayer, String skinValue, String animationStyle, int animationDuration) {
        try {
            Class<?> senderClass = Class.forName("com.zeydie.skinchanger.utils.ServerPacketSender");
            Method sendMethod = senderClass.getMethod("sendSkinPacket", class_3222.class, String.class, String.class, String.class, String.class, Integer.TYPE);
            sendMethod.invoke(null, (class_3222)targetPlayer, targetPlayer.method_7334().getId().toString(), targetPlayer.method_7334().getName(), skinValue, animationStyle, animationDuration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Integer setPlayerSkinByURL(class_2165 sourcePlayer, class_1657 targetPlayer, URL url) {
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.loading")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerSkinByURL(targetPlayer.method_7334(), url, true)) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.load_failed")}));
            } else {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.load_succeeded")}));
            }
        });
        return 1;
    }

    private static Integer setPlayerCape(class_2168 source, class_1297 targetEntity, String arg) {
        MinecraftServer sourcePlayer = source.method_9211();
        if (source.method_9228() != null) {
            sourcePlayer = source.method_9228();
        }
        class_1657 targetPlayer = (class_1657)targetEntity;
        try {
            URL url = new URL(arg);
            return SkinsCommand.setPlayerCapeByURL((class_2165)sourcePlayer, targetPlayer, url);
        }
        catch (MalformedURLException e) {
            return SkinsCommand.setPlayerCapeByName((class_2165)sourcePlayer, targetPlayer, arg);
        }
    }

    private static Integer setPlayerCapeByName(class_2165 sourcePlayer, class_1657 targetPlayer, String playerName) {
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.loading")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerCapeByName(targetPlayer.method_7334(), playerName, true)) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.load_failed")}));
            } else {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.load_succeeded")}));
            }
        });
        return 1;
    }

    private static Integer setPlayerCapeByURL(class_2165 sourcePlayer, class_1657 targetPlayer, URL url) {
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.loading")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerCapeByURL(targetPlayer.method_7334(), url, true)) {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.load_failed")}));
            } else {
                sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.load_succeeded")}));
            }
        });
        return 1;
    }

    private static Integer clearPlayerSkin(class_2168 source, class_1297 targetEntity) throws CommandSyntaxException {
        class_1657 sourcePlayer = (class_1657)source.method_9229();
        class_1657 targetPlayer = (class_1657)targetEntity;
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.removing")}));
        SharedPool.get().execute(() -> {
            SkinProviderController.GetInstance().clearPlayerSkin(targetPlayer.method_7334());
            sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.skin.remove_succeeded")}));
        });
        return 1;
    }

    private static Integer clearPlayerCape(class_2168 source, class_1297 targetEntity) throws CommandSyntaxException {
        class_1657 sourcePlayer = (class_1657)source.method_9229();
        class_1657 targetPlayer = (class_1657)targetEntity;
        sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.removing")}));
        SharedPool.get().execute(() -> {
            SkinProviderController.GetInstance().clearPlayerCape(targetPlayer.method_7334());
            sourcePlayer.method_43496((class_2561)class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, class_2561.method_43471((String)"commands.skin_changer.cape.remove_succeeded")}));
        });
        return 1;
    }

    @FunctionalInterface
    public static interface Function3<T, U, V, R> {
        public R apply(T var1, U var2, V var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface Function2<T, U, R> {
        public R apply(T var1, U var2) throws CommandSyntaxException;
    }
}

