/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.common.messages.PlayerSkinRequestMessage;
import me.edoren.skin_changer.server.SkinProviderController;
import net.fabricmc.api.EnvType;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;

public class ServerMessageHandler {
    public static void onMessageReceived(PlayerSkinRequestMessage message, Supplier<NetworkManager.PacketContext> ctxSupplier) {
        NetworkManager.PacketContext ctx = ctxSupplier.get();
        EnvType toPlatform = ctx.getEnvironment().toPlatform();
        if (toPlatform != EnvType.SERVER) {
            LogManager.getLogger().warn("PlayerSkinRequestMessage received on wrong side: {}", (Object)toPlatform);
            return;
        }
        if (!message.isMessageValid()) {
            LogManager.getLogger().warn("PlayerSkinRequestMessage was invalid: {}", (Object)message);
            return;
        }
        class_3222 sendingPlayer = (class_3222)ctx.getPlayer();
        if (sendingPlayer == null) {
            LogManager.getLogger().warn("EntityPlayer was null when PlayerSkinRequestMessage was received");
        }
        ctx.queue(() -> ServerMessageHandler.processMessage(message, sendingPlayer));
    }

    static void processMessage(PlayerSkinRequestMessage message, class_3222 sendingPlayer) {
        SharedPool.execute(() -> {
            GameProfile profile = message.getPlayer().toGameProfile();
            LogManager.getLogger().info("Requested skin for player {}[{}]", (Object)profile.getName(), (Object)profile.getId());
            if (!SkinProviderController.GetInstance().getPlayerSkin(profile, sendingPlayer)) {
                SkinProviderController.GetInstance().setPlayerSkinByName(profile, message.getPlayer().getName(), false);
            }
        });
    }
}

