/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.common.models;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class PlayerModel {
    private final String name;
    private final String uuid;

    public PlayerModel(GameProfile profile) {
        String name = profile.getName();
        UUID id = profile.getId();
        this.name = name;
        this.uuid = id != null ? id.toString() : null;
    }

    public PlayerModel(String name, String uuid) {
        if (uuid == null && StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name and UUID cannot both be blank");
        }
        this.name = name;
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerModel that = (PlayerModel)o;
        return Objects.equals(this.name, that.name) || Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.uuid;
    }

    public String toString() {
        return String.format("%s[%s]", this.name, this.uuid);
    }

    public GameProfile toGameProfile() {
        return new GameProfile(UUID.fromString(this.uuid), this.name);
    }
}

