/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.common.messages;

import me.edoren.skin_changer.common.models.PlayerModel;
import net.minecraft.class_2540;
import org.apache.logging.log4j.LogManager;

public class PlayerSkinRequestMessage {
    private PlayerModel player;
    private boolean messageIsValid;

    public PlayerSkinRequestMessage(PlayerModel player) {
        this.player = player;
        this.messageIsValid = true;
    }

    PlayerSkinRequestMessage() {
        this.messageIsValid = false;
    }

    public static PlayerSkinRequestMessage decode(class_2540 buf) {
        PlayerSkinRequestMessage ret = new PlayerSkinRequestMessage();
        try {
            int bufferSize = buf.readInt();
            String name = buf.method_10800(bufferSize);
            bufferSize = buf.readInt();
            String uuid = buf.method_10800(bufferSize);
            ret.player = new PlayerModel(name, uuid);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            LogManager.getLogger().error("Exception while reading PlayerSkinUpdateMessage", (Throwable)e);
            ret.messageIsValid = false;
            return ret;
        }
        ret.messageIsValid = true;
        return ret;
    }

    public PlayerModel getPlayer() {
        return this.player;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public void encode(class_2540 buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.player.getName().length());
        buf.method_10814(this.player.getName());
        buf.writeInt(this.player.getId().length());
        buf.method_10814(this.player.getId());
    }
}

