/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client;

import dev.architectury.networking.NetworkManager;
import java.util.Vector;
import java.util.function.Supplier;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.messages.PlayerSkinUpdateMessage;
import me.edoren.skin_changer.common.models.PlayerSkinModel;
import net.fabricmc.api.EnvType;
import org.apache.logging.log4j.LogManager;

public class ClientMessageHandler {
    public static void onMessageReceived(PlayerSkinUpdateMessage message, Supplier<NetworkManager.PacketContext> ctxSupplier) {
        NetworkManager.PacketContext ctx = ctxSupplier.get();
        EnvType toPlatform = ctx.getEnvironment().toPlatform();
        if (toPlatform != EnvType.CLIENT) {
            LogManager.getLogger().warn("PlayerSkinUpdateMessage received on wrong side: {}", (Object)toPlatform);
            return;
        }
        if (!message.isMessageValid()) {
            LogManager.getLogger().warn("PlayerSkinUpdateMessage was invalid: {}", (Object)message);
            return;
        }
        ctx.queue(() -> ClientMessageHandler.processMessage(message));
    }

    private static void processMessage(PlayerSkinUpdateMessage message) {
        Vector<PlayerSkinModel> skinData = message.getAllSkinData();
        if (skinData.isEmpty()) {
            SkinLoaderService.GetInstance().clear();
            return;
        }
        for (PlayerSkinModel playerData : skinData) {
            SkinLoaderService.GetInstance().loadPlayerSkin(playerData.getPlayer(), playerData.getSkin());
            SkinLoaderService.GetInstance().loadPlayerCape(playerData.getPlayer(), playerData.getCape());
        }
    }
}

