/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client;

import dev.architectury.event.events.client.ClientTickEvent;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import me.edoren.skin_changer.client.CustomSkinTexture;
import me.edoren.skin_changer.client.api.ISkin;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.models.PlayerModel;
import me.edoren.skin_changer.server.SkinProviderController;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;

public class ClientController {
    private static ClientController singleInstance = null;
    final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();

    private ClientController() {
    }

    public static ClientController GetInstance() {
        if (singleInstance == null) {
            singleInstance = new ClientController();
        }
        return singleInstance;
    }

    public void initialize() {
        Path savesFolder = Paths.get("cache", new String[0]);
        File skinChangerFolder = Paths.get(savesFolder.toString(), "skin_changer").normalize().toFile();
        SkinProviderController.GetInstance().initialize(skinChangerFolder);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTickEvent);
    }

    public void deinitialize() {
        ClientTickEvent.CLIENT_PRE.unregister(this::onClientTickEvent);
    }

    public class_2960 getLocationCape(PlayerModel model) {
        ISkin cape = SkinLoaderService.GetInstance().getCape(model);
        if (cape != null && cape.isDataReady()) {
            return this.getOrCreateTexture(cape.getData(), cape).getLocation();
        }
        return null;
    }

    public class_2960 getLocationSkin(PlayerModel model) {
        try {
            Class<?> visibilityManagerClass = Class.forName("com.zeydie.skinchanger.textures.VisibilityTextureManager");
            Object visibilityManager = visibilityManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            class_2960 visibilityLoc = (class_2960)visibilityManagerClass.getMethod("getTextureLocation", PlayerModel.class).invoke(visibilityManager, model);
            if (visibilityLoc != null) {
                return visibilityLoc;
            }
        }
        catch (Exception visibilityManagerClass) {
            // empty catch block
        }
        ISkin skin = SkinLoaderService.GetInstance().getSkin(model);
        if (skin != null && skin.isDataReady()) {
            return this.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public String getSkinType(PlayerModel model) {
        ISkin skin;
        class_2960 location = this.getLocationSkin(model);
        if (location != null && (skin = SkinLoaderService.GetInstance().getSkin(model)) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return null;
    }

    public CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!this.textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(this.generateRandomLocation(), data);
            class_310.method_1551().method_1531().method_4616(texture.getLocation(), (class_1044)texture);
            this.textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        class_310.method_1551().execute(() -> {
                            class_310.method_1551().method_1531().method_4615(texture.getLocation());
                            this.textures.remove(data);
                        });
                    }
                });
            }
        }
        return this.textures.get(data);
    }

    private void onClientTickEvent(class_310 mc) {
        class_638 world = mc.field_1687;
        if (world != null) {
            for (class_742 player : world.method_18456()) {
                PlayerModel model = new PlayerModel(player.method_7334());
                SkinLoaderService.GetInstance().getSkin(model);
                SkinLoaderService.GetInstance().getCape(model);
            }
        }
    }

    private class_2960 generateRandomLocation() {
        return new class_2960("skin_changer", String.format("textures/generated/%s", UUID.randomUUID()));
    }
}

