/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import me.edoren.skin_changer.client.ClientController;
import me.edoren.skin_changer.common.NetworkContext;
import me.edoren.skin_changer.server.ServerController;
import me.edoren.skin_changer.server.SkinsCommand;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public final class SkinChanger {
    public SkinChanger() {
        LifecycleEvent.SETUP.register(this::onSetup);
        if (Platform.getEnvironment() == Env.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(this::onClientSetup);
            ClientLifecycleEvent.CLIENT_STOPPING.register(this::onClientStopping);
        }
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        LifecycleEvent.SERVER_STOPPED.register(this::onServerStopped);
        CommandRegistrationEvent.EVENT.register(this::onCommandRegistration);
    }

    void onSetup() {
        NetworkContext.GetInstance().initialize();
    }

    void onClientSetup(class_310 client) {
        ClientController.GetInstance().initialize();
    }

    void onClientStopping(class_310 client) {
        ClientController.GetInstance().deinitialize();
    }

    void onServerStarted(MinecraftServer server) {
        ServerController.GetInstance().initialize(server);
    }

    void onServerStopped(MinecraftServer server) {
        ServerController.GetInstance().deinitialize(server);
    }

    void onCommandRegistration(CommandDispatcher<class_2168> commandSourceStackCommandDispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        SkinsCommand.register(commandSourceStackCommandDispatcher);
    }
}

