/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.utils;

import com.zeydie.sgson.SGsonBase;
import com.zeydie.skinchanger.packets.SkinPlayerPacket;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketSender {
    private static final Logger LOGGER = LogManager.getLogger((String)"ServerPacketSender");
    private static final class_2960 SKIN_CHANNEL = new class_2960("skinchanger", "channel");

    public static void sendSkinPacket(class_3222 target, String playerUuid, String playerName, String skinUrl, String animationStyle, int animationDuration) {
        try {
            SkinPlayerPacket packet = new SkinPlayerPacket(playerUuid, playerName, skinUrl, true, animationStyle, animationDuration);
            String json = SGsonBase.create().fromObjectToJson((Object)packet);
            byte[] data = json.getBytes(StandardCharsets.UTF_8);
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBytes(data);
            ServerPlayNetworking.send((class_3222)target, (class_2960)SKIN_CHANNEL, (class_2540)buf);
            LOGGER.info("Sent skin packet to {}: skin={}, animation={}, duration={}", (Object)target.method_5477().getString(), (Object)skinUrl, (Object)animationStyle, (Object)animationDuration);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send skin packet to {}", (Object)target.method_5477().getString(), (Object)e);
        }
    }

    public static void sendSkinPacketToAll(List<class_3222> players, String playerUuid, String playerName, String skinUrl, String animationStyle, int animationDuration) {
        for (class_3222 player : players) {
            ServerPacketSender.sendSkinPacket(player, playerUuid, playerName, skinUrl, animationStyle, animationDuration);
        }
    }

    public static void sendOriginalSkinPacket(class_3222 target, String playerUuid, String playerName, String animationStyle, int animationDuration) {
        ServerPacketSender.sendSkinPacket(target, playerUuid, playerName, "original", animationStyle, animationDuration);
    }

    public static void sendOriginalSkinPacketToAll(List<class_3222> players, String playerUuid, String playerName, String animationStyle, int animationDuration) {
        ServerPacketSender.sendSkinPacketToAll(players, playerUuid, playerName, "original", animationStyle, animationDuration);
    }
}

