/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.utils;

import me.edoren.skin_changer.common.models.PlayerModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerVisibilityHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static float getPlayerAlpha(PlayerModel playerModel) {
        try {
            Integer alphaValue;
            Class<?> alphaManagerClass = Class.forName("com.zeydie.skinchanger.alpha.PlayerAlphaManager");
            Object alphaManager = alphaManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Boolean hasAlpha = (Boolean)alphaManagerClass.getMethod("hasAlpha", PlayerModel.class).invoke(alphaManager, playerModel);
            if (hasAlpha != null && hasAlpha.booleanValue() && (alphaValue = (Integer)alphaManagerClass.getMethod("getAlpha", PlayerModel.class).invoke(alphaManager, playerModel)) != null) {
                return (float)alphaValue.intValue() / 255.0f;
            }
            Class<?> visManagerClass = Class.forName("com.zeydie.skinchanger.animation.PlayerVisibilityManager");
            Object visManager = visManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Boolean hasTransition = (Boolean)visManagerClass.getMethod("hasActiveTransition", PlayerModel.class).invoke(visManager, playerModel);
            if (hasTransition != null && hasTransition.booleanValue()) {
                return 0.5f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0f;
    }

    public static boolean isPlayerTransparent(PlayerModel playerModel) {
        return PlayerVisibilityHelper.getPlayerAlpha(playerModel) < 1.0f;
    }

    public static boolean isPlayerInvisible(PlayerModel playerModel) {
        return PlayerVisibilityHelper.getPlayerAlpha(playerModel) <= 0.01f;
    }
}

