/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.edoren.skin_changer.client.ImageUtils;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalSkinLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadSkinFromFile(File file) {
        if (file == null || !file.exists()) {
            LOGGER.error("Skin file does not exist: {}", (Object)file);
            return null;
        }
        if (!file.getName().toLowerCase().endsWith(".png")) {
            LOGGER.error("Skin file must be a PNG image: {}", (Object)file.getName());
            return null;
        }
        try {
            byte[] data = Files.readAllBytes(file.toPath());
            if (ImageUtils.isNotValidData(data)) {
                LOGGER.error("Invalid skin image data: {}", (Object)file.getName());
                return null;
            }
            try (class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));){
                int width = image.method_4307();
                int height = image.method_4323();
                if (width < 64 || height < 32) {
                    LOGGER.error("Skin dimensions too small ({}x{}): {}", (Object)width, (Object)height, (Object)file.getName());
                    byte[] byArray = null;
                    return byArray;
                }
                if (width != height && width != height * 2) {
                    LOGGER.error("Invalid skin dimensions ({}x{}): {}", (Object)width, (Object)height, (Object)file.getName());
                    byte[] byArray = null;
                    return byArray;
                }
                LOGGER.info("Successfully loaded skin from file: {} ({}x{})", (Object)file.getName(), (Object)width, (Object)height);
                return data;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load skin from file: {}", (Object)file.getName(), (Object)e);
            return null;
        }
    }

    public static byte[] loadSkinFromPath(String filePath) {
        return LocalSkinLoader.loadSkinFromFile(new File(filePath));
    }
}

