/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.textures;

import com.google.common.collect.Maps;
import com.zeydie.skinchanger.textures.StrongSkinTexture;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.UUID;
import me.edoren.skin_changer.common.models.PlayerModel;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisibilityTextureManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static VisibilityTextureManager instance;
    private final Map<PlayerModel, StrongSkinTexture> activeTextures = Maps.newHashMap();
    private final Map<PlayerModel, class_2960> textureLocations = Maps.newHashMap();

    private VisibilityTextureManager() {
    }

    public static VisibilityTextureManager getInstance() {
        if (instance == null) {
            instance = new VisibilityTextureManager();
        }
        return instance;
    }

    public class_2960 loadVisibilityFrame(PlayerModel playerModel, byte[] frameData) {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(frameData.length).order(ByteOrder.nativeOrder());
            buffer.put(frameData);
            buffer.rewind();
            class_2960 location = this.textureLocations.get(playerModel);
            if (location == null) {
                location = new class_2960("skin_changer", "visibility/" + playerModel.getId().toLowerCase() + "_" + UUID.randomUUID());
                this.textureLocations.put(playerModel, location);
            }
            StrongSkinTexture texture = new StrongSkinTexture(location, buffer);
            class_1060 textureManager = class_310.method_1551().method_1531();
            textureManager.method_4616(location, (class_1044)texture);
            this.activeTextures.put(playerModel, texture);
            return location;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load visibility frame", (Throwable)e);
            return null;
        }
    }

    public class_2960 getTextureLocation(PlayerModel playerModel) {
        return this.textureLocations.get(playerModel);
    }

    public boolean hasTexture(PlayerModel playerModel) {
        return this.activeTextures.containsKey(playerModel);
    }

    public void clearTexture(PlayerModel playerModel) {
        class_2960 location;
        StrongSkinTexture texture = this.activeTextures.remove(playerModel);
        if (texture != null) {
            texture.cleanup();
        }
        if ((location = this.textureLocations.remove(playerModel)) != null) {
            class_1060 textureManager = class_310.method_1551().method_1531();
            textureManager.method_4615(location);
        }
        LOGGER.info("Cleared visibility texture for {}", (Object)playerModel.getName());
    }

    public void clearAll() {
        for (PlayerModel player : this.activeTextures.keySet()) {
            this.clearTexture(player);
        }
        LOGGER.info("Cleared all visibility textures");
    }
}

