/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.library;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zeydie.skinchanger.library.SkinEntry;
import com.zeydie.skinchanger.utils.LocalSkinLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinLibrary {
    private static final Logger LOGGER = LogManager.getLogger((String)"SkinLibrary");
    private static SkinLibrary instance;
    private final File libraryDir;
    private final File skinsDir;
    private final File catalogFile;
    private final Map<String, SkinEntry> skins = Maps.newHashMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private SkinLibrary() {
        File minecraftDir = class_310.method_1551().field_1697;
        this.libraryDir = new File(minecraftDir, "skinchanger");
        this.skinsDir = new File(this.libraryDir, "library");
        this.catalogFile = new File(this.libraryDir, "catalog.json");
        if (!this.skinsDir.exists()) {
            this.skinsDir.mkdirs();
            LOGGER.info("Created skin library directory: {}", (Object)this.skinsDir.getAbsolutePath());
        }
        this.loadCatalog();
    }

    public static SkinLibrary getInstance() {
        if (instance == null) {
            instance = new SkinLibrary();
        }
        return instance;
    }

    private void loadCatalog() {
        if (!this.catalogFile.exists()) {
            LOGGER.info("Catalog file not found, starting with empty library");
            this.saveCatalog();
            return;
        }
        try {
            String json = Files.readString(this.catalogFile.toPath());
            SkinEntry[] entries = (SkinEntry[])this.gson.fromJson(json, SkinEntry[].class);
            this.skins.clear();
            if (entries != null) {
                for (SkinEntry entry : entries) {
                    this.skins.put(entry.getId(), entry);
                }
            }
            LOGGER.info("Loaded {} skins from catalog", (Object)this.skins.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load catalog", (Throwable)e);
        }
    }

    private void saveCatalog() {
        try {
            SkinEntry[] entries = this.skins.values().toArray(new SkinEntry[0]);
            String json = this.gson.toJson((Object)entries);
            Files.writeString(this.catalogFile.toPath(), (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Saved catalog with {} skins", (Object)this.skins.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save catalog", (Throwable)e);
        }
    }

    public boolean addSkin(String id, String name, File sourceFile, String description) {
        if (id == null || id.trim().isEmpty()) {
            LOGGER.error("Skin ID cannot be empty");
            return false;
        }
        if (this.skins.containsKey(id)) {
            LOGGER.error("Skin with ID '{}' already exists", (Object)id);
            return false;
        }
        byte[] skinData = LocalSkinLoader.loadSkinFromFile(sourceFile);
        if (skinData == null) {
            LOGGER.error("Invalid skin file: {}", (Object)sourceFile.getAbsolutePath());
            return false;
        }
        try {
            String filename = id + ".png";
            File destFile = new File(this.skinsDir, filename);
            Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            SkinEntry entry = new SkinEntry();
            entry.setId(id);
            entry.setName(name);
            entry.setFilename(filename);
            entry.setDescription(description);
            entry.setAddedTime(System.currentTimeMillis());
            entry.setTags(new String[0]);
            this.skins.put(id, entry);
            this.saveCatalog();
            LOGGER.info("Added skin '{}' to library", (Object)name);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to add skin to library", (Throwable)e);
            return false;
        }
    }

    public boolean removeSkin(String id) {
        SkinEntry entry = this.skins.get(id);
        if (entry == null) {
            LOGGER.error("Skin with ID '{}' not found", (Object)id);
            return false;
        }
        File skinFile = new File(this.skinsDir, entry.getFilename());
        if (skinFile.exists() && !skinFile.delete()) {
            LOGGER.warn("Failed to delete skin file: {}", (Object)skinFile.getAbsolutePath());
        }
        this.skins.remove(id);
        this.saveCatalog();
        LOGGER.info("Removed skin '{}' from library", (Object)entry.getName());
        return true;
    }

    public SkinEntry getSkinEntry(String id) {
        return this.skins.get(id);
    }

    public byte[] loadSkinData(String id) {
        SkinEntry entry = this.skins.get(id);
        if (entry == null) {
            LOGGER.error("Skin with ID '{}' not found", (Object)id);
            return null;
        }
        File skinFile = new File(this.skinsDir, entry.getFilename());
        byte[] data = LocalSkinLoader.loadSkinFromFile(skinFile);
        if (data == null) {
            LOGGER.error("Failed to load skin file for ID '{}'", (Object)id);
        }
        return data;
    }

    public Set<String> getAllSkinIds() {
        return new HashSet<String>(this.skins.keySet());
    }

    public Collection<SkinEntry> getAllSkins() {
        return new ArrayList<SkinEntry>(this.skins.values());
    }

    public boolean hasSkin(String id) {
        return this.skins.containsKey(id);
    }

    public int size() {
        return this.skins.size();
    }

    public List<SkinEntry> search(String query) {
        String lowerQuery = query.toLowerCase();
        ArrayList<SkinEntry> results = new ArrayList<SkinEntry>();
        for (SkinEntry entry : this.skins.values()) {
            if (!entry.getName().toLowerCase().contains(lowerQuery) && !entry.getId().toLowerCase().contains(lowerQuery) && (entry.getDescription() == null || !entry.getDescription().toLowerCase().contains(lowerQuery))) continue;
            results.add(entry);
        }
        return results;
    }

    public boolean updateSkin(String id, String newName, String newDescription, String[] newTags) {
        SkinEntry entry = this.skins.get(id);
        if (entry == null) {
            return false;
        }
        if (newName != null) {
            entry.setName(newName);
        }
        if (newDescription != null) {
            entry.setDescription(newDescription);
        }
        if (newTags != null) {
            entry.setTags(newTags);
        }
        this.saveCatalog();
        return true;
    }

    public File getLibraryDirectory() {
        return this.skinsDir;
    }

    public void loadSkinsFromResources() {
        LOGGER.info("Loading skins from mod resources...");
        try {
            class_2960 skinsConfig = new class_2960("skin_changer", "skins/skins.json");
            class_310 minecraft = class_310.method_1551();
            Optional resourceOpt = minecraft.method_1478().method_14486(skinsConfig);
            if (resourceOpt.isEmpty()) {
                LOGGER.info("No skins.json found in resources, skipping preload");
                return;
            }
            class_3298 resource = (class_3298)resourceOpt.get();
            try (InputStream is = resource.method_14482();){
                String json = new String(is.readAllBytes());
                PreloadConfig config = (PreloadConfig)this.gson.fromJson(json, PreloadConfig.class);
                if (config == null || config.skins == null) {
                    LOGGER.warn("Invalid skins.json format");
                    return;
                }
                int loaded = 0;
                for (PreloadSkinEntry entry : config.skins) {
                    if (!this.loadSkinFromResources(entry)) continue;
                    ++loaded;
                }
                LOGGER.info("Loaded {} skins from mod resources", (Object)loaded);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load skins from resources", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadSkinFromResources(PreloadSkinEntry entry) {
        try {
            byte[] skinData;
            if (this.skins.containsKey(entry.id)) {
                LOGGER.debug("Skin '{}' already exists, skipping", (Object)entry.id);
                return false;
            }
            class_2960 skinLocation = new class_2960("skin_changer", "skins/" + entry.file);
            class_310 minecraft = class_310.method_1551();
            Optional resourceOpt = minecraft.method_1478().method_14486(skinLocation);
            if (resourceOpt.isEmpty()) {
                LOGGER.warn("Skin file not found in resources: {}", (Object)entry.file);
                return false;
            }
            class_3298 resource = (class_3298)resourceOpt.get();
            try (InputStream is = resource.method_14482();){
                skinData = is.readAllBytes();
            }
            if (LocalSkinLoader.loadSkinFromFile(new File(entry.file)) == null) {
                File tempFile = File.createTempFile("skin_validate_", ".png");
                try {
                    Files.write(tempFile.toPath(), skinData, new OpenOption[0]);
                    byte[] validated = LocalSkinLoader.loadSkinFromFile(tempFile);
                    if (validated == null) {
                        LOGGER.warn("Invalid skin data in resources: {}", (Object)entry.file);
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    tempFile.delete();
                }
            }
            File destFile = new File(this.skinsDir, entry.id + ".png");
            Files.write(destFile.toPath(), skinData, new OpenOption[0]);
            SkinEntry catalogEntry = new SkinEntry();
            catalogEntry.setId(entry.id);
            catalogEntry.setName(entry.name);
            catalogEntry.setFilename(entry.id + ".png");
            catalogEntry.setDescription(entry.description);
            catalogEntry.setAddedTime(System.currentTimeMillis());
            catalogEntry.setTags(entry.tags != null ? entry.tags : new String[]{});
            this.skins.put(entry.id, catalogEntry);
            LOGGER.info("Loaded skin from resources: {} ({})", (Object)entry.name, (Object)entry.id);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load skin '{}' from resources", (Object)entry.id, (Object)e);
            return false;
        }
    }

    @Generated
    public Map<String, SkinEntry> getSkins() {
        return this.skins;
    }

    private static class PreloadConfig {
        List<PreloadSkinEntry> skins;

        private PreloadConfig() {
        }
    }

    private static class PreloadSkinEntry {
        String id;
        String name;
        String file;
        String description;
        String[] tags;

        private PreloadSkinEntry() {
        }
    }
}

