/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.handlers;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.zeydie.sgson.SGsonBase;
import com.zeydie.skinchanger.alpha.PlayerAlphaManager;
import com.zeydie.skinchanger.animation.AnimatedSkinTransition;
import com.zeydie.skinchanger.animation.PlayerVisibilityManager;
import com.zeydie.skinchanger.animation.SkinTransitionManager;
import com.zeydie.skinchanger.library.SkinLibrary;
import com.zeydie.skinchanger.packets.LoadSkinByIdPacket;
import com.zeydie.skinchanger.packets.PlayerAlphaPacket;
import com.zeydie.skinchanger.packets.PlayerVisibilityPacket;
import com.zeydie.skinchanger.packets.SkinPlayerPacket;
import com.zeydie.skinchanger.utils.LocalSkinLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.edoren.skin_changer.client.api.ISkin;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.NetworkUtils;
import me.edoren.skin_changer.common.models.PlayerModel;
import me.edoren.skin_changer.fabric.SkinChangerFabric;
import me.edoren.skin_changer.server.SkinProviderController;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;

public final class PacketHandler {
    private static final Logger LOGGER = SkinChangerFabric.LOGGER;
    public static final class_2960 SKIN_CHANNEL = new class_2960("skinchanger", "channel");
    public static final class_2960 LIBRARY_CHANNEL = new class_2960("skinchanger", "library");
    public static final class_2960 VISIBILITY_CHANNEL = new class_2960("skinchanger", "visibility");
    public static final class_2960 ALPHA_CHANNEL = new class_2960("skinchanger", "alpha");
    static boolean next = false;
    private static final Map<String, String> playersSkins = new HashMap<String, String>();
    private static final Map<PlayerModelSkin, byte[]> cache = Maps.newHashMap();
    private static final Map<String, Integer> lastAnimatedSkinHash = Maps.newHashMap();
    private static boolean enableAnimations = true;
    private static AnimatedSkinTransition.TransitionStyle defaultTransitionStyle = AnimatedSkinTransition.TransitionStyle.RADIAL;
    private static int defaultTransitionDuration = 20;

    public static void registerHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SKIN_CHANNEL, (minecraft, clientPacketListener, friendlyByteBuf, packetSender) -> {
            try {
                byte[] bytes = new byte[friendlyByteBuf.readableBytes()];
                friendlyByteBuf.duplicate().readBytes(bytes);
                PacketHandler.handleSkinPacket(bytes);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)e);
                e.printStackTrace();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LIBRARY_CHANNEL, (minecraft, clientPacketListener, friendlyByteBuf, packetSender) -> {
            try {
                byte[] bytes = new byte[friendlyByteBuf.readableBytes()];
                friendlyByteBuf.duplicate().readBytes(bytes);
                PacketHandler.handleLibraryPacket(bytes);
            }
            catch (Exception e) {
                LOGGER.error("Error handling library packet", (Throwable)e);
                e.printStackTrace();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)VISIBILITY_CHANNEL, (minecraft, clientPacketListener, friendlyByteBuf, packetSender) -> {
            try {
                byte[] bytes = new byte[friendlyByteBuf.readableBytes()];
                friendlyByteBuf.duplicate().readBytes(bytes);
                PacketHandler.handleVisibilityPacket(bytes);
            }
            catch (Exception e) {
                LOGGER.error("Error handling visibility packet", (Throwable)e);
                e.printStackTrace();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ALPHA_CHANNEL, (minecraft, clientPacketListener, friendlyByteBuf, packetSender) -> {
            try {
                byte[] bytes = new byte[friendlyByteBuf.readableBytes()];
                friendlyByteBuf.duplicate().readBytes(bytes);
                PacketHandler.handleAlphaPacket(bytes);
            }
            catch (Exception e) {
                LOGGER.error("Error handling alpha packet", (Throwable)e);
                e.printStackTrace();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Player disconnected from server, clearing skin cache");
            PacketHandler.clearCache();
        });
    }

    private static void handleSkinPacket(byte[] array) throws MalformedURLException {
        boolean hasAnimation;
        String json = new String(array, StandardCharsets.UTF_8);
        SkinPlayerPacket packet = (SkinPlayerPacket)SGsonBase.create().fromJsonToObject(json, (Object)new SkinPlayerPacket());
        String uuid = packet.getUuid();
        String name = packet.getName();
        String skin = packet.getSkin();
        String animation = packet.getAnimation();
        int animationDuration = packet.getAnimationDuration() > 0 ? packet.getAnimationDuration() : 20;
        boolean forceUpdate = packet.isUpdated();
        PlayerModel playerModel = new PlayerModel(name, uuid);
        PlayerModelSkin playerModelSkin = new PlayerModelSkin(playerModel, skin);
        SkinProviderController controller = SkinProviderController.GetInstance();
        SkinLoaderService loader = SkinLoaderService.GetInstance();
        boolean bl = hasAnimation = animation != null && !animation.isEmpty() && !animation.equalsIgnoreCase("none");
        if (forceUpdate && hasAnimation) {
            LOGGER.info("Force update flag set, clearing hash to allow animation");
            lastAnimatedSkinHash.remove(uuid);
        }
        if (hasAnimation) {
            try {
                AnimatedSkinTransition.TransitionStyle style = AnimatedSkinTransition.TransitionStyle.valueOf(animation.toUpperCase());
                PacketHandler.setTransitionStyle(style);
                PacketHandler.setTransitionDuration(animationDuration);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid animation style: {}, using default", (Object)animation);
            }
        }
        try {
            if (skin.equalsIgnoreCase("default")) {
                playersSkins.remove(uuid);
                controller.clearPlayerSkin(name, uuid);
                loader.loadPlayerSkin(playerModel, null);
                return;
            }
            if (skin.equalsIgnoreCase("original") || skin.toLowerCase().startsWith("original:")) {
                String targetPlayerName = name;
                if (skin.toLowerCase().startsWith("original:")) {
                    targetPlayerName = skin.substring(9);
                }
                PacketHandler.loadOriginalSkin(playerModel, targetPlayerName, hasAnimation);
                playersSkins.put(uuid, skin);
                return;
            }
            if (skin.startsWith("lib:")) {
                String skinId = skin.substring(4);
                PacketHandler.handleLibrarySkin(playerModel, skinId, hasAnimation);
                playersSkins.put(uuid, skin);
                return;
            }
            if (playersSkins.containsKey(uuid)) {
                if (!playersSkins.get(uuid).equalsIgnoreCase(skin)) {
                    playersSkins.replace(uuid, skin);
                    cachedData = cache.get(playerModelSkin);
                    if (cachedData != null) {
                        if (hasAnimation) {
                            PacketHandler.loadSkinWithAnimation(playerModel, cachedData);
                        } else {
                            loader.loadPlayerSkin(playerModel, cachedData);
                        }
                    } else {
                        PacketHandler.loadUrlSkinWithAnimation(playerModel, playerModelSkin, skin, hasAnimation);
                    }
                }
            } else {
                playersSkins.put(uuid, skin);
                cachedData = cache.get(playerModelSkin);
                if (cachedData != null) {
                    if (hasAnimation) {
                        PacketHandler.loadSkinWithAnimation(playerModel, cachedData);
                    } else {
                        loader.loadPlayerSkin(playerModel, cachedData);
                    }
                } else {
                    PacketHandler.loadUrlSkinWithAnimation(playerModel, playerModelSkin, skin, hasAnimation);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error handling skin packet", (Throwable)exception);
            exception.printStackTrace();
        }
    }

    private static void handleLibrarySkin(PlayerModel playerModel, String skinId, boolean useAnimation) {
        SkinLibrary library = SkinLibrary.getInstance();
        if (!library.hasSkin(skinId)) {
            LOGGER.error("Skin '{}' not found in library for player {}", (Object)skinId, (Object)playerModel.getName());
            return;
        }
        byte[] skinData = library.loadSkinData(skinId);
        if (skinData == null) {
            LOGGER.error("Failed to load skin data for ID '{}'", (Object)skinId);
            return;
        }
        LOGGER.info("Applying library skin '{}' to player {}", (Object)skinId, (Object)playerModel.getName());
        if (useAnimation) {
            PacketHandler.loadSkinWithAnimation(playerModel, skinData);
        } else {
            SkinLoaderService.GetInstance().loadPlayerSkin(playerModel, skinData);
        }
    }

    private static void loadOriginalSkin(PlayerModel playerModel, String targetPlayerName, boolean useAnimation) {
        LOGGER.info("Loading original skin for player '{}' (target: {})", (Object)playerModel.getName(), (Object)targetPlayerName);
        CompletableFuture.supplyAsync(() -> {
            try {
                String skinUrl = "https://skins.votive-rp.com/SKIN/STORAGE/" + targetPlayerName;
                LOGGER.info("Downloading original skin from: {}", (Object)skinUrl);
                byte[] skinData = NetworkUtils.downloadFile(skinUrl, null, 2);
                if (skinData == null || skinData.length == 0) {
                    LOGGER.error("Failed to download original skin for '{}'", (Object)targetPlayerName);
                    return null;
                }
                LOGGER.info("Successfully downloaded original skin for '{}' ({} bytes)", (Object)targetPlayerName, (Object)skinData.length);
                return skinData;
            }
            catch (Exception e) {
                LOGGER.error("Error loading original skin for '{}'", (Object)targetPlayerName, (Object)e);
                return null;
            }
        }).thenAcceptAsync(skinData -> {
            if (skinData != null) {
                if (useAnimation) {
                    LOGGER.info("Applying original skin for '{}' with animation", (Object)targetPlayerName);
                    PacketHandler.loadSkinWithAnimation(playerModel, skinData);
                } else {
                    LOGGER.info("Applying original skin for '{}' without animation", (Object)targetPlayerName);
                    SkinLoaderService.GetInstance().loadPlayerSkin(playerModel, (byte[])skinData);
                }
            }
        });
    }

    private static void loadUrlSkinWithAnimation(PlayerModel playerModel, PlayerModelSkin playerModelSkin, String skinUrl, boolean useAnimation) {
        SkinProviderController controller = SkinProviderController.GetInstance();
        SkinLoaderService loader = SkinLoaderService.GetInstance();
        CompletableFuture.supplyAsync(() -> {
            try {
                byte[] skinData;
                boolean success = controller.setPlayerSkinByURL(playerModel, new URL(skinUrl), false);
                if (success && (skinData = controller.getPlayerSkinData(playerModel).getSkin()) != null) {
                    if (!cache.containsKey(playerModelSkin)) {
                        cache.put(playerModelSkin, skinData);
                    } else {
                        cache.replace(playerModelSkin, skinData);
                    }
                    return skinData;
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error("Invalid skin URL: {}", (Object)skinUrl, (Object)e);
            }
            return null;
        }).thenAcceptAsync(skinData -> {
            if (skinData != null) {
                if (useAnimation) {
                    LOGGER.info("Skin loaded from URL, applying with animation for {}", (Object)playerModel.getName());
                    PacketHandler.loadSkinWithAnimation(playerModel, skinData);
                } else {
                    LOGGER.info("Skin loaded from URL, applying without animation for {}", (Object)playerModel.getName());
                    loader.loadPlayerSkin(playerModel, (byte[])skinData);
                }
            } else {
                LOGGER.error("Failed to load skin from URL for {}", (Object)playerModel.getName());
            }
        });
    }

    private static void handleLibraryPacket(byte[] array) {
        String json = new String(array, StandardCharsets.UTF_8);
        LOGGER.info("Received library packet: {}", (Object)json);
        LoadSkinByIdPacket packet = (LoadSkinByIdPacket)SGsonBase.create().fromJsonToObject(json, (Object)new LoadSkinByIdPacket());
        String skinId = packet.getSkinId();
        String targetUuid = packet.getTargetUuid();
        String targetName = packet.getTargetName();
        SkinLibrary library = SkinLibrary.getInstance();
        if (!library.hasSkin(skinId)) {
            LOGGER.error("Skin with ID '{}' not found in library", (Object)skinId);
            return;
        }
        byte[] skinData = library.loadSkinData(skinId);
        if (skinData == null) {
            LOGGER.error("Failed to load skin data for ID '{}'", (Object)skinId);
            return;
        }
        if (packet.getAnimationStyle() != null && !packet.getAnimationStyle().isEmpty()) {
            try {
                AnimatedSkinTransition.TransitionStyle style = AnimatedSkinTransition.TransitionStyle.valueOf(packet.getAnimationStyle().toUpperCase());
                PacketHandler.setTransitionStyle(style);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid animation style: {}", (Object)packet.getAnimationStyle());
            }
        }
        if (packet.getAnimationDuration() > 0) {
            PacketHandler.setTransitionDuration(packet.getAnimationDuration());
        }
        if (packet.isApplyToAllAround()) {
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player != null && minecraft.field_1687 != null) {
                class_243 targetPos = player.method_19538();
                double radius = packet.getRadius();
                int count = 0;
                for (class_742 otherPlayer : minecraft.field_1687.method_18456()) {
                    if (!(otherPlayer.method_19538().method_1022(targetPos) <= radius)) continue;
                    GameProfile gameProfile = otherPlayer.method_7334();
                    PlayerModel playerModel = new PlayerModel(gameProfile.getName(), gameProfile.getId().toString());
                    PacketHandler.loadSkinWithAnimation(playerModel, skinData);
                    ++count;
                }
                LOGGER.info("Applied skin '{}' to {} players within {} blocks", (Object)skinId, (Object)count, (Object)radius);
            }
        } else {
            PlayerModel playerModel = new PlayerModel(targetName, targetUuid);
            PacketHandler.loadSkinWithAnimation(playerModel, skinData);
            LOGGER.info("Applied skin '{}' to player {}", (Object)skinId, (Object)targetName);
        }
    }

    private static void loadSkinWithAnimation(PlayerModel playerModel, byte[] newSkinData) {
        SkinLoaderService loader = SkinLoaderService.GetInstance();
        SkinTransitionManager transitionManager = SkinTransitionManager.getInstance();
        PlayerVisibilityManager visibilityManager = PlayerVisibilityManager.getInstance();
        if (visibilityManager.hasActiveTransition(playerModel)) {
            LOGGER.info("Skipping skin load - visibility animation active for {}", (Object)playerModel.getName());
            return;
        }
        if (!enableAnimations) {
            loader.loadPlayerSkin(playerModel, newSkinData);
            return;
        }
        int newSkinHash = Arrays.hashCode(newSkinData);
        String uuid = playerModel.getId();
        if (lastAnimatedSkinHash.containsKey(uuid)) {
            int lastHash = lastAnimatedSkinHash.get(uuid);
            if (lastHash == newSkinHash) {
                return;
            }
            LOGGER.info("Detected skin change (hash {} -> {}), will animate", (Object)lastHash, (Object)newSkinHash);
        }
        if (transitionManager.hasActiveTransition(playerModel)) {
            LOGGER.info("Animation already in progress for {}, waiting for completion", (Object)playerModel.getName());
            return;
        }
        ISkin oldSkin = loader.getSkin(playerModel);
        byte[] oldSkinData = null;
        if (oldSkin != null) {
            try {
                ByteBuffer buffer = oldSkin.getData();
                if (buffer != null) {
                    oldSkinData = new byte[buffer.remaining()];
                    buffer.duplicate().get(oldSkinData);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not get old skin data for animation", (Throwable)e);
            }
        }
        lastAnimatedSkinHash.put(uuid, newSkinHash);
        LOGGER.info("Starting {} skin transition for {} (duration: {} ticks)", (Object)defaultTransitionStyle, (Object)playerModel.getName(), (Object)defaultTransitionDuration);
        transitionManager.startTransition(playerModel, oldSkinData, newSkinData, defaultTransitionStyle, defaultTransitionDuration);
    }

    public static boolean loadLocalSkin(PlayerModel playerModel, String filePath) {
        byte[] skinData = LocalSkinLoader.loadSkinFromPath(filePath);
        if (skinData == null) {
            LOGGER.error("Failed to load local skin from: {}", (Object)filePath);
            return false;
        }
        LOGGER.info("Loading local skin for {} from: {}", (Object)playerModel.getName(), (Object)filePath);
        PlayerModelSkin playerModelSkin = new PlayerModelSkin(playerModel, "local:" + filePath);
        cache.put(playerModelSkin, skinData);
        PacketHandler.loadSkinWithAnimation(playerModel, skinData);
        return true;
    }

    public static void setAnimationEnabled(boolean enabled) {
        enableAnimations = enabled;
        LOGGER.info("Skin animations {}", (Object)(enabled ? "enabled" : "disabled"));
    }

    public static boolean isAnimationEnabled() {
        return enableAnimations;
    }

    public static void toggleAnimations() {
        PacketHandler.setAnimationEnabled(!enableAnimations);
    }

    public static void setTransitionStyle(AnimatedSkinTransition.TransitionStyle style) {
        defaultTransitionStyle = style;
        LOGGER.info("Transition style set to: {}", (Object)style);
    }

    public static void setTransitionDuration(int ticks) {
        defaultTransitionDuration = Math.max(1, ticks);
        LOGGER.info("Transition duration set to: {} ticks", (Object)defaultTransitionDuration);
    }

    private static void handleVisibilityPacket(byte[] array) {
        String json = new String(array, StandardCharsets.UTF_8);
        LOGGER.info("Received visibility packet: {}", (Object)json);
        PlayerVisibilityPacket packet = (PlayerVisibilityPacket)SGsonBase.create().fromJsonToObject(json, (Object)new PlayerVisibilityPacket());
        String uuid = packet.getUuid();
        String name = packet.getName();
        boolean hide = packet.isHide();
        String hexColor = packet.getHexColor() != null ? packet.getHexColor() : "FF0000";
        String mode = packet.getMode() != null ? packet.getMode() : "linear";
        int duration = packet.getDuration() > 0 ? packet.getDuration() : 20;
        PlayerModel playerModel = new PlayerModel(name, uuid);
        PlayerVisibilityManager visibilityManager = PlayerVisibilityManager.getInstance();
        SkinLoaderService loader = SkinLoaderService.GetInstance();
        LOGGER.info("Received visibility: hide={}, color=#{}, mode={}, duration={}", (Object)hide, (Object)hexColor, (Object)mode, (Object)duration);
        if (hide) {
            ISkin currentSkin = loader.getSkin(playerModel);
            if (currentSkin != null) {
                try {
                    ByteBuffer buffer = currentSkin.getData();
                    if (buffer != null) {
                        byte[] skinData2 = new byte[buffer.remaining()];
                        buffer.duplicate().get(skinData2);
                        visibilityManager.hidePlayer(playerModel, skinData2, hexColor, mode, duration);
                        LOGGER.info("Started hide animation for {}", (Object)name);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error starting hide animation", (Throwable)e);
                }
            } else {
                LOGGER.info("No custom skin for {}, downloading from server to hide...", (Object)name);
                SkinProviderController controller = SkinProviderController.GetInstance();
                CompletableFuture.supplyAsync(() -> {
                    try {
                        String skinUrl = "https://skins.votive-rp.com/SKIN/STORAGE/" + name;
                        LOGGER.info("Downloading skin from: {}", (Object)skinUrl);
                        boolean success = controller.setPlayerSkinByURL(playerModel, new URL(skinUrl), false);
                        if (success) {
                            byte[] skinData = controller.getPlayerSkinData(playerModel).getSkin();
                            LOGGER.info("Downloaded skin ({} bytes), starting hide animation", (Object)skinData.length);
                            return skinData;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to download skin: {}", (Object)e.getMessage());
                    }
                    return null;
                }).thenAcceptAsync(skinData -> {
                    if (skinData != null) {
                        visibilityManager.hidePlayer(playerModel, (byte[])skinData, hexColor, mode, duration);
                        LOGGER.info("Started hide animation for {}", (Object)name);
                    } else {
                        LOGGER.error("Cannot hide player {}, no skin available", (Object)name);
                    }
                });
            }
        } else {
            ISkin currentSkin = loader.getSkin(playerModel);
            if (currentSkin != null) {
                try {
                    ByteBuffer buffer = currentSkin.getData();
                    if (buffer != null) {
                        byte[] skinData3 = new byte[buffer.remaining()];
                        buffer.duplicate().get(skinData3);
                        visibilityManager.showPlayer(playerModel, skinData3, hexColor, mode, duration);
                        LOGGER.info("Started show animation for {}", (Object)name);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error starting show animation", (Throwable)e);
                }
            } else {
                LOGGER.info("No skin for {}, downloading for show animation...", (Object)name);
                SkinProviderController controller = SkinProviderController.GetInstance();
                CompletableFuture.supplyAsync(() -> {
                    try {
                        String skinUrl = "https://skins.votive-rp.com/SKIN/STORAGE/" + name;
                        boolean success = controller.setPlayerSkinByURL(playerModel, new URL(skinUrl), false);
                        if (success) {
                            return controller.getPlayerSkinData(playerModel).getSkin();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to download skin: {}", (Object)e.getMessage());
                    }
                    return null;
                }).thenAcceptAsync(skinData -> {
                    if (skinData != null) {
                        visibilityManager.showPlayer(playerModel, (byte[])skinData, hexColor, mode, duration);
                        LOGGER.info("Started show animation for {} (downloaded)", (Object)name);
                    }
                });
            }
        }
    }

    private static void handleAlphaPacket(byte[] array) {
        String json = new String(array, StandardCharsets.UTF_8);
        LOGGER.info("Received alpha packet: {}", (Object)json);
        PlayerAlphaPacket packet = (PlayerAlphaPacket)SGsonBase.create().fromJsonToObject(json, (Object)new PlayerAlphaPacket());
        String uuid = packet.getUuid();
        String name = packet.getName();
        int alpha = packet.getAlpha();
        boolean reset = packet.isReset();
        PlayerModel playerModel = new PlayerModel(name, uuid);
        PlayerAlphaManager alphaManager = PlayerAlphaManager.getInstance();
        SkinLoaderService loader = SkinLoaderService.GetInstance();
        if (reset) {
            alphaManager.resetPlayer(playerModel);
            LOGGER.info("Reset alpha for {}", (Object)name);
        } else {
            ISkin currentSkin = loader.getSkin(playerModel);
            if (currentSkin != null) {
                try {
                    ByteBuffer buffer = currentSkin.getData();
                    if (buffer != null) {
                        byte[] skinData2 = new byte[buffer.remaining()];
                        buffer.duplicate().get(skinData2);
                        alphaManager.setPlayerAlpha(playerModel, skinData2, alpha);
                        LOGGER.info("Set alpha {} for {}", (Object)alpha, (Object)name);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error setting alpha", (Throwable)e);
                }
            } else {
                LOGGER.info("No skin for {}, downloading...", (Object)name);
                SkinProviderController controller = SkinProviderController.GetInstance();
                CompletableFuture.supplyAsync(() -> {
                    try {
                        String skinUrl = "https://skins.votive-rp.com/SKIN/STORAGE/" + name;
                        boolean success = controller.setPlayerSkinByURL(playerModel, new URL(skinUrl), false);
                        if (success) {
                            return controller.getPlayerSkinData(playerModel).getSkin();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to download skin: {}", (Object)e.getMessage());
                    }
                    return null;
                }).thenAcceptAsync(skinData -> {
                    if (skinData != null) {
                        alphaManager.setPlayerAlpha(playerModel, (byte[])skinData, alpha);
                        LOGGER.info("Set alpha {} for {} (downloaded)", (Object)alpha, (Object)name);
                    }
                });
            }
        }
    }

    public static void clearCache() {
        LOGGER.info("Clearing {} cached skins and {} player skin mappings", (Object)cache.size(), (Object)playersSkins.size());
        cache.clear();
        playersSkins.clear();
        lastAnimatedSkinHash.clear();
        SkinLoaderService.GetInstance().clear();
        SkinTransitionManager.getInstance().clearAll();
        PlayerVisibilityManager.getInstance().clearAll();
        PlayerAlphaManager.getInstance().clearAll();
    }

    private record PlayerModelSkin(PlayerModel playerModel, String skin) {
    }
}

