/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zeydie.skinchanger.library.SkinEntry;
import com.zeydie.skinchanger.library.SkinLibrary;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class SkinLibraryCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skinlib").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"id", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(SkinLibraryCommand::addSkin)))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(SkinLibraryCommand::removeSkin)))).then(ClientCommandManager.literal((String)"list").executes(SkinLibraryCommand::listSkins))).then(ClientCommandManager.literal((String)"info").then(ClientCommandManager.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(SkinLibraryCommand::showSkinInfo)))).then(ClientCommandManager.literal((String)"search").then(ClientCommandManager.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(SkinLibraryCommand::searchSkins)))).then(ClientCommandManager.literal((String)"dir").executes(SkinLibraryCommand::showDirectory))).executes(SkinLibraryCommand::showHelp));
    }

    private static int showHelp(CommandContext<FabricClientCommandSource> context) {
        SkinLibraryCommand.sendMessage("\u00a76=== Skin Library Commands ===");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib add <id> <name> <path> \u00a77- Add skin to library");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib remove <id> \u00a77- Remove skin from library");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib list \u00a77- List all skins in library");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib info <id> \u00a77- Show skin information");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib search <query> \u00a77- Search skins by name");
        SkinLibraryCommand.sendMessage("\u00a7e/skinlib dir \u00a77- Show library directory path");
        SkinLibraryCommand.sendMessage("");
        SkinLibraryCommand.sendMessage("\u00a77Note: Server can use /applyskin to apply library skins");
        return 1;
    }

    private static int addSkin(CommandContext<FabricClientCommandSource> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        String name = StringArgumentType.getString(context, (String)"name");
        String path = StringArgumentType.getString(context, (String)"path");
        SkinLibrary library = SkinLibrary.getInstance();
        File file = new File(path);
        if (!file.exists()) {
            SkinLibraryCommand.sendMessage("\u00a7cFile not found: " + path);
            return 0;
        }
        if (library.addSkin(id, name, file, null)) {
            SkinLibraryCommand.sendMessage("\u00a7aAdded skin '" + name + "' with ID: \u00a7e" + id);
            SkinLibraryCommand.sendMessage("\u00a77Total skins in library: " + library.size());
            return 1;
        }
        SkinLibraryCommand.sendMessage("\u00a7cFailed to add skin! Check if ID already exists or file is invalid.");
        return 0;
    }

    private static int removeSkin(CommandContext<FabricClientCommandSource> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        SkinLibrary library = SkinLibrary.getInstance();
        if (library.removeSkin(id)) {
            SkinLibraryCommand.sendMessage("\u00a7aRemoved skin with ID: \u00a7e" + id);
            SkinLibraryCommand.sendMessage("\u00a77Total skins in library: " + library.size());
            return 1;
        }
        SkinLibraryCommand.sendMessage("\u00a7cSkin with ID '" + id + "' not found!");
        return 0;
    }

    private static int listSkins(CommandContext<FabricClientCommandSource> context) {
        SkinLibrary library = SkinLibrary.getInstance();
        Collection<SkinEntry> skins = library.getAllSkins();
        if (skins.isEmpty()) {
            SkinLibraryCommand.sendMessage("\u00a77Library is empty. Use \u00a7e/skinlib add\u00a77 to add skins.");
            return 1;
        }
        SkinLibraryCommand.sendMessage("\u00a76=== Skin Library (" + skins.size() + " skins) ===");
        for (SkinEntry entry : skins) {
            SkinLibraryCommand.sendMessage("\u00a7e" + entry.getId() + " \u00a77- \u00a7f" + entry.getName());
        }
        SkinLibraryCommand.sendMessage("\u00a77Use \u00a7e/skinlib info <id>\u00a77 for more details");
        return 1;
    }

    private static int showSkinInfo(CommandContext<FabricClientCommandSource> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        SkinLibrary library = SkinLibrary.getInstance();
        SkinEntry entry = library.getSkinEntry(id);
        if (entry == null) {
            SkinLibraryCommand.sendMessage("\u00a7cSkin with ID '" + id + "' not found!");
            return 0;
        }
        SkinLibraryCommand.sendMessage("\u00a76=== Skin Info ===");
        SkinLibraryCommand.sendMessage("\u00a7eID: \u00a7f" + entry.getId());
        SkinLibraryCommand.sendMessage("\u00a7eName: \u00a7f" + entry.getName());
        if (entry.getDescription() != null && !entry.getDescription().isEmpty()) {
            SkinLibraryCommand.sendMessage("\u00a7eDescription: \u00a7f" + entry.getDescription());
        }
        SkinLibraryCommand.sendMessage("\u00a7eFilename: \u00a77" + entry.getFilename());
        SkinLibraryCommand.sendMessage("\u00a7eAdded: \u00a77" + new Date(entry.getAddedTime()));
        if (entry.getTags() != null && entry.getTags().length > 0) {
            SkinLibraryCommand.sendMessage("\u00a7eTags: \u00a77" + String.join((CharSequence)", ", entry.getTags()));
        }
        return 1;
    }

    private static int searchSkins(CommandContext<FabricClientCommandSource> context) {
        String query = StringArgumentType.getString(context, (String)"query");
        SkinLibrary library = SkinLibrary.getInstance();
        List<SkinEntry> results = library.search(query);
        if (results.isEmpty()) {
            SkinLibraryCommand.sendMessage("\u00a77No skins found matching: \u00a7e" + query);
            return 1;
        }
        SkinLibraryCommand.sendMessage("\u00a76=== Search Results (" + results.size() + ") ===");
        for (SkinEntry entry : results) {
            SkinLibraryCommand.sendMessage("\u00a7e" + entry.getId() + " \u00a77- \u00a7f" + entry.getName());
        }
        return 1;
    }

    private static int showDirectory(CommandContext<FabricClientCommandSource> context) {
        SkinLibrary library = SkinLibrary.getInstance();
        File dir = library.getLibraryDirectory();
        SkinLibraryCommand.sendMessage("\u00a76=== Skin Library Directory ===");
        SkinLibraryCommand.sendMessage("\u00a77Path: \u00a7e" + dir.getAbsolutePath());
        SkinLibraryCommand.sendMessage("\u00a77Skins stored: \u00a7e" + library.size());
        SkinLibraryCommand.sendMessage("");
        SkinLibraryCommand.sendMessage("\u00a77You can manually copy PNG files here and use \u00a7e/skinlib add\u00a77 to register them");
        return 1;
    }

    private static void sendMessage(String message) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null) {
            minecraft.field_1724.method_43496((class_2561)class_2561.method_43470((String)message));
        }
    }
}

